/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.diagnostics.error.ErrorTextProvider;
import com.helger.diagnostics.error.IHasErrorField;
import com.helger.diagnostics.error.IHasErrorID;
import com.helger.diagnostics.error.level.IHasErrorLevelComparable;
import com.helger.diagnostics.error.text.IHasErrorText;
import java.time.LocalDateTime;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IError
extends IHasErrorLevelComparable<IError>,
IHasErrorID,
IHasErrorField {
    default public @Nullable LocalDateTime getErrorDateTime() {
        return null;
    }

    default public boolean hasErrorDateTime() {
        return this.getErrorDateTime() != null;
    }

    @Override
    default public String getErrorID() {
        return null;
    }

    @Override
    default public @Nullable String getErrorFieldName() {
        return null;
    }

    default public @NonNull ILocation getErrorLocation() {
        return SimpleLocation.NO_LOCATION;
    }

    default public boolean hasErrorLocation() {
        return this.getErrorLocation().isAnyInformationPresent();
    }

    default public @Nullable IHasErrorText getErrorTexts() {
        return null;
    }

    default public @Nullable String getErrorText(@NonNull Locale locale) {
        IHasErrorText iHasErrorText = this.getErrorTexts();
        return iHasErrorText == null ? null : iHasErrorText.getDisplayText(locale);
    }

    default public @Nullable Throwable getLinkedException() {
        return null;
    }

    default public boolean hasLinkedException() {
        return this.getLinkedException() != null;
    }

    default public @Nullable String getLinkedExceptionMessage() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getMessage();
    }

    default public @Nullable StackTraceElement[] getLinkedExceptionStackTrace() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getStackTrace();
    }

    default public @Nullable Throwable getLinkedExceptionCause() {
        Throwable throwable = this.getLinkedException();
        return throwable == null ? null : throwable.getCause();
    }

    default public @NonNull @Nonempty String getAsString(@NonNull Locale locale) {
        return ErrorTextProvider.DEFAULT.getErrorText(this, locale);
    }

    default public @NonNull @Nonempty String getAsStringLocaleIndepdent() {
        return this.getAsString(Locale.ROOT);
    }
}

