/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.text;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.text.TextFormatter;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.text.IHasErrorText;
import com.helger.text.IHasText;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
@MustImplementEqualsAndHashcode
public class DynamicHasErrorTextWithArgs
implements IHasErrorText {
    private final IHasText m_aParentText;
    private final Object[] m_aArgs;

    public DynamicHasErrorTextWithArgs(@Nonnull IHasDisplayText iHasDisplayText, Object ... objectArray) {
        this(iHasDisplayText.getAsHasText(), objectArray);
    }

    public DynamicHasErrorTextWithArgs(@Nonnull IHasText iHasText, Object ... objectArray) {
        this.m_aParentText = (IHasText)ValueEnforcer.notNull((Object)iHasText, (String)"ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty((Object[])objectArray, (String)"Arguments");
    }

    @Nonnull
    public IHasText getParentText() {
        return this.m_aParentText;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Object[] getAllArgs() {
        return ArrayHelper.getCopy((Object[])this.m_aArgs);
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        String string = this.m_aParentText.getText(locale);
        return TextFormatter.getFormattedText((String)string, (Object[])this.m_aArgs);
    }

    @Override
    public boolean isMultiLingual() {
        return true;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("parentText", (Object)this.m_aParentText).append("args", this.m_aArgs).getToString();
    }
}

