/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jspecify.annotations.NonNull;

@Immutable
public final class PDTIOHelper {
    public static final String PATTERN_DATE = "uuuuMMdd";
    public static final String PATTERN_TIME = "HHmmss";
    public static final String PATTERN_DATETIME = "uuuuMMdd_HHmmss";
    private static final PDTIOHelper INSTANCE = new PDTIOHelper();

    private PDTIOHelper() {
    }

    public static @NonNull String getCurrentLocalDateTimeForFilename() {
        return PDTIOHelper.getLocalDateTimeForFilename(PDTFactory.getCurrentLocalDateTime());
    }

    public static @NonNull String getLocalDateTimeForFilename(@NonNull LocalDateTime localDateTime) {
        return PDTToString.getAsString(PATTERN_DATETIME, localDateTime);
    }

    public static String getCurrentDateForFilename() {
        return PDTIOHelper.getDateForFilename(PDTFactory.getCurrentLocalDate());
    }

    public static String getDateForFilename(@NonNull LocalDate localDate) {
        return PDTToString.getAsString(PATTERN_DATE, localDate);
    }

    public static String getCurrentTimeForFilename() {
        return PDTIOHelper.getTimeForFilename(PDTFactory.getCurrentLocalTime());
    }

    public static String getTimeForFilename(@NonNull LocalTime localTime) {
        return PDTToString.getAsString(PATTERN_TIME, localTime);
    }
}

