/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.concurrent.Immutable;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatter;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PDTToString {
    private static final PDTToString INSTANCE = new PDTToString();

    private PDTToString() {
    }

    public static @Nullable String getAsString(@Nullable LocalDate localDate, @NonNull Locale locale) {
        return localDate == null ? null : PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDate);
    }

    public static @Nullable String getAsString(@Nullable OffsetDate offsetDate, @NonNull Locale locale) {
        return offsetDate == null ? null : PDTFormatter.getFormatterOffsetDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDate);
    }

    public static @Nullable String getAsString(@Nullable XMLOffsetDate xMLOffsetDate, @NonNull Locale locale) {
        if (xMLOffsetDate == null) {
            return null;
        }
        if (xMLOffsetDate.hasOffset()) {
            return PDTFormatter.getFormatterOffsetDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDate);
        }
        return PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDate.toLocalDate());
    }

    public static @Nullable String getAsString(@Nullable LocalTime localTime, @NonNull Locale locale) {
        return localTime == null ? null : PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localTime);
    }

    public static @Nullable String getAsString(@Nullable OffsetTime offsetTime, @NonNull Locale locale) {
        return offsetTime == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetTime);
    }

    public static @Nullable String getAsString(@Nullable XMLOffsetTime xMLOffsetTime, @NonNull Locale locale) {
        if (xMLOffsetTime == null) {
            return null;
        }
        if (xMLOffsetTime.hasOffset()) {
            return PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetTime);
        }
        return PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetTime.toLocalTime());
    }

    public static @Nullable String getAsString(@Nullable LocalDateTime localDateTime, @NonNull Locale locale) {
        return localDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDateTime);
    }

    public static @Nullable String getAsString(@Nullable ZonedDateTime zonedDateTime, @NonNull Locale locale) {
        return zonedDateTime == null ? null : PDTFormatter.getFormatterZonedDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(zonedDateTime);
    }

    public static @Nullable String getAsString(@Nullable OffsetDateTime offsetDateTime, @NonNull Locale locale) {
        return offsetDateTime == null ? null : PDTFormatter.getFormatterOffsetDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDateTime);
    }

    public static @Nullable String getAsString(@Nullable XMLOffsetDateTime xMLOffsetDateTime, @NonNull Locale locale) {
        if (xMLOffsetDateTime == null) {
            return null;
        }
        if (xMLOffsetDateTime.hasOffset()) {
            return PDTFormatter.getFormatterOffsetDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDateTime);
        }
        return PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDateTime.toLocalDateTime());
    }

    public static @Nullable String getAsString(@NonNull String string, @Nullable TemporalAccessor temporalAccessor) {
        return PDTToString.getAsString(string, temporalAccessor, null);
    }

    public static @Nullable String getAsString(@NonNull String string, @Nullable TemporalAccessor temporalAccessor, @Nullable Locale locale) {
        return temporalAccessor == null ? null : PDTFormatter.getForPattern(string, locale).format(temporalAccessor);
    }
}

