/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringReplace;
import com.helger.cache.impl.Cache;
import com.helger.datetime.EDTType;
import com.helger.datetime.format.DateTimeFormatterCache;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatPatterns;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

@Immutable
public final class PDTFormatter {
    public static final FormatStyle DEFAULT_STYLE = FormatStyle.MEDIUM;
    private static final LocalizedDateFormatCache PARSER_CACHE = new LocalizedDateFormatCache();
    private static final PDTFormatter INSTANCE = new PDTFormatter();

    private PDTFormatter() {
    }

    @Nonnull
    public static FormatStyle toFormatStyle(int n) {
        switch (n) {
            case 0: {
                return FormatStyle.FULL;
            }
            case 1: {
                return FormatStyle.LONG;
            }
            case 2: {
                return FormatStyle.MEDIUM;
            }
            case 3: {
                return FormatStyle.SHORT;
            }
        }
        throw new IllegalArgumentException("Invalid style passed: " + n);
    }

    public static int toDateStyle(@Nonnull FormatStyle formatStyle) {
        switch (formatStyle) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unsupported style passed: " + String.valueOf((Object)formatStyle));
    }

    @Nonnull
    public static String getPattern(@Nonnull EDTType eDTType, @Nullable Locale locale, @Nonnull FormatStyle formatStyle, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return LocalizedDateFormatCache.getSourcePattern(new CacheKey(eDTType, locale, formatStyle, eDTFormatterMode));
    }

    @Nonnull
    public static DateTimeFormatter getWithLocale(@Nonnull DateTimeFormatter dateTimeFormatter, @Nullable Locale locale) {
        DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter;
        if (locale != null) {
            dateTimeFormatter2 = dateTimeFormatter2.withLocale(locale);
        }
        return dateTimeFormatter2;
    }

    @Nonnull
    private static DateTimeFormatter _getFormatter(@Nonnull CacheKey cacheKey, @Nullable Locale locale) {
        DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)PARSER_CACHE.getFromCache(cacheKey);
        return PDTFormatter.getWithLocale(dateTimeFormatter, locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterDate(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_DATE, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterOffsetDate(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.OFFSET_DATE, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_TIME, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterOffsetTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.OFFSET_TIME, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterDateTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_DATE_TIME, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterOffsetDateTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.OFFSET_DATE_TIME, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterZonedDateTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EDTFormatterMode eDTFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.ZONED_DATE_TIME, locale, formatStyle, eDTFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string) {
        return PDTFormatter.getForPattern(string, null);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string, @Nullable Locale locale) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatterCache.getDateTimeFormatterStrict(string);
        return PDTFormatter.getWithLocale(dateTimeFormatter, locale);
    }

    @Immutable
    public static final class CacheKey {
        private final EDTType m_eDTType;
        private final Locale m_aLocale;
        private final FormatStyle m_eStyle;
        private final EDTFormatterMode m_eMode;

        CacheKey(@Nonnull EDTType eDTType, @Nullable Locale locale, @Nonnull FormatStyle formatStyle, @Nonnull EDTFormatterMode eDTFormatterMode) {
            ValueEnforcer.notNull((Object)((Object)eDTType), (String)"DTType");
            ValueEnforcer.notNull((Object)((Object)formatStyle), (String)"Style");
            ValueEnforcer.notNull((Object)((Object)eDTFormatterMode), (String)"Mode");
            this.m_eDTType = eDTType;
            this.m_aLocale = locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
            this.m_eStyle = formatStyle;
            this.m_eMode = eDTFormatterMode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this.m_eDTType.equals((Object)cacheKey.m_eDTType) && this.m_aLocale.equals(cacheKey.m_aLocale) && this.m_eStyle.equals((Object)cacheKey.m_eStyle) && this.m_eMode == cacheKey.m_eMode;
        }

        public int hashCode() {
            return new HashCodeGenerator((Object)this).append((Object)this.m_eDTType).append((Object)this.m_aLocale).append((Object)this.m_eStyle).append((Object)this.m_eMode).getHashCode();
        }
    }

    @ThreadSafe
    public static final class LocalizedDateFormatCache
    extends Cache<CacheKey, DateTimeFormatter> {
        public LocalizedDateFormatCache() {
            super(cacheKey -> {
                String string = LocalizedDateFormatCache.getSourcePattern(cacheKey);
                string = StringReplace.replaceAll((String)string, (char)'y', (char)'u');
                if (cacheKey.m_eMode == EDTFormatterMode.PARSE && "de".equals(cacheKey.m_aLocale.getLanguage()) && cacheKey.m_eStyle == FormatStyle.MEDIUM) {
                    string = StringReplace.replaceAll((String)string, (String)"dd", (CharSequence)"d");
                    string = StringReplace.replaceAll((String)string, (String)"MM", (CharSequence)"M");
                    string = StringReplace.replaceAll((String)string, (String)"HH", (CharSequence)"H");
                    string = StringReplace.replaceAll((String)string, (String)"mm", (CharSequence)"m");
                    string = StringReplace.replaceAll((String)string, (String)"ss", (CharSequence)"s");
                }
                return DateTimeFormatterCache.getDateTimeFormatterStrict(string);
            }, 1000, LocalizedDateFormatCache.class.getName());
        }

        @Nonnull
        public static String getSourcePattern(@Nonnull CacheKey cacheKey) {
            switch (cacheKey.m_eDTType) {
                case LOCAL_TIME: {
                    return PDTFormatPatterns.getPatternTime(cacheKey.m_eStyle, cacheKey.m_aLocale);
                }
                case OFFSET_TIME: {
                    return PDTFormatPatterns.getPatternTime(cacheKey.m_eStyle, cacheKey.m_aLocale) + " Z";
                }
                case LOCAL_DATE: {
                    return PDTFormatPatterns.getPatternDate(cacheKey.m_eStyle, cacheKey.m_aLocale);
                }
                case OFFSET_DATE: {
                    return PDTFormatPatterns.getPatternDate(cacheKey.m_eStyle, cacheKey.m_aLocale) + " Z";
                }
                case LOCAL_DATE_TIME: {
                    return PDTFormatPatterns.getPatternDateTime(cacheKey.m_eStyle, cacheKey.m_aLocale);
                }
                case OFFSET_DATE_TIME: {
                    return PDTFormatPatterns.getPatternDateTime(cacheKey.m_eStyle, cacheKey.m_aLocale) + " Z";
                }
                case ZONED_DATE_TIME: {
                    return PDTFormatPatterns.getPatternDateTime(cacheKey.m_eStyle, cacheKey.m_aLocale) + " z";
                }
            }
            throw new IllegalStateException("Unsupported DTType " + String.valueOf((Object)cacheKey.m_eDTType));
        }
    }
}

