/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.wal;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.IsLocked;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.EAppend;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.EChange;
import com.helger.base.state.ESuccess;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.dao.AbstractDAO;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.dao.wal.WALListener;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.io.file.EFileIOErrorCode;
import com.helger.io.file.EFileIOOperation;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import com.helger.io.relative.IFileRelativeIO;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractWALDAO<DATATYPE>
extends AbstractDAO {
    public static final Duration DEFAULT_WAITING_TIME = Duration.ofSeconds(10L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWALDAO.class);
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterInitTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$init"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterReadTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$read"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-success"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteExceptions = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-exceptions"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterWriteTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$write"));
    public static final IXMLWriterSettings WRITE_XWS = new XMLWriterSettings().setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.WRITE_TO_FILE_NO_LOG);
    public static final IXMLWriterSettings WAL_XWS = new XMLWriterSettings().setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.WRITE_TO_FILE_NO_LOG).setIndent(EXMLSerializeIndent.NONE);
    private final Class<DATATYPE> m_aDataTypeClass;
    private final IFileRelativeIO m_aIO;
    private final Supplier<String> m_aFilenameProvider;
    private String m_sPreviousFilename;
    private int m_nInitCount = 0;
    private LocalDateTime m_aLastInitDT;
    private int m_nReadCount = 0;
    private LocalDateTime m_aLastReadDT;
    private int m_nWriteCount = 0;
    private LocalDateTime m_aLastWriteDT;
    private boolean m_bCanWriteWAL = true;
    private Duration m_aWaitingTime = DEFAULT_WAITING_TIME;
    private final WALListener m_aWALListener;

    private static @NonNull String _getFilenameNew(@NonNull String string) {
        return string + ".new";
    }

    private static @NonNull String _getFilenamePrev(@NonNull String string) {
        return string + ".prev";
    }

    protected AbstractWALDAO(@NonNull Class<DATATYPE> clazz, @NonNull IFileRelativeIO iFileRelativeIO, @NonNull Supplier<String> supplier) {
        this.m_aDataTypeClass = (Class)ValueEnforcer.notNull(clazz, (String)"DataTypeClass");
        this.m_aIO = (IFileRelativeIO)ValueEnforcer.notNull((Object)iFileRelativeIO, (String)"DAOIO");
        this.m_aFilenameProvider = (Supplier)ValueEnforcer.notNull(supplier, (String)"FilenameProvider");
        this.m_aWALListener = WALListener.getInstance();
        String string = this.m_aFilenameProvider.get();
        if (string != null) {
            File file;
            try {
                file = this.getSafeFile(AbstractWALDAO._getFilenameNew(string), IDAO.EMode.WRITE);
                if (file.exists()) {
                    String string2 = "The temporary WAL file '" + file.getAbsolutePath() + "' already exists! If the '.new' file is complete, rename it to match '" + string + "'. Please resolve this conflict manually.";
                    LOGGER.error(string2);
                    throw new IllegalStateException(string2);
                }
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
            try {
                file = this.getSafeFile(AbstractWALDAO._getFilenamePrev(string), IDAO.EMode.WRITE);
                if (file.exists()) {
                    String string3 = "The temporary WAL file '" + file.getAbsolutePath() + "' already exists! If the target filename '" + string + "' exists and is complete, you may consider deleting this '.prev' file. Please resolve this conflict manually.";
                    LOGGER.error(string3);
                    throw new IllegalStateException(string3);
                }
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
        }
    }

    final void internalWriteLocked(@NonNull Runnable runnable) {
        this.m_aRWLock.writeLocked(runnable);
    }

    protected final @NonNull IFileRelativeIO getIO() {
        return this.m_aIO;
    }

    public final @NonNull Supplier<String> getFilenameProvider() {
        return this.m_aFilenameProvider;
    }

    @OverrideOnDemand
    protected @NonNull EChange onInit() {
        return EChange.UNCHANGED;
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected abstract @NonNull EChange onRead(@NonNull IMicroDocument var1);

    protected final @NonNull File getSafeFile(@NonNull String string, @NonNull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)string, (String)"Filename");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        File file = this.m_aIO.getFile(string);
        AbstractWALDAO.checkFileAccess(file, eMode);
        return file;
    }

    protected static void triggerExceptionHandlersRead(@NonNull Throwable throwable, boolean bl, @Nullable File file) {
        if (AbstractWALDAO.exceptionHandlersRead().isNotEmpty()) {
            FileSystemResource fileSystemResource = file == null ? null : new FileSystemResource(file);
            AbstractWALDAO.exceptionHandlersRead().forEach(arg_0 -> AbstractWALDAO.lambda$triggerExceptionHandlersRead$0(throwable, bl, (IReadableResource)fileSystemResource, arg_0));
        }
    }

    protected final @NonNull Class<DATATYPE> getDataTypeClass() {
        return this.m_aDataTypeClass;
    }

    @OverrideOnDemand
    @IsLocked(value=ELockType.WRITE)
    protected @Nullable DATATYPE convertWALStringToNative(@NonNull String string) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((String)string);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            return null;
        }
        return (DATATYPE)MicroTypeConverter.convertToNative((IMicroElement)iMicroDocument.getDocumentElement(), this.m_aDataTypeClass);
    }

    @OverrideOnDemand
    @IsLocked(value=ELockType.WRITE)
    protected void onBetweenReadAndWAL(@NonNull IMicroDocument iMicroDocument) {
    }

    @OverrideOnDemand
    protected void onRecoveryErrorConvertToNative(@NonNull EDAOActionType eDAOActionType, @Nonnegative int n, @NonNull String string) {
        LOGGER.error("Action [" + String.valueOf((Object)eDAOActionType) + "][" + n + "]: failed to convert the following element to native:\n" + string);
    }

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryCreate(@NonNull DATATYPE var1);

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryUpdate(@NonNull DATATYPE var1);

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryDelete(@NonNull DATATYPE var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialRead() throws DAOException {
        block49: {
            File file;
            String string = this.m_aFilenameProvider.get();
            if (string == null) {
                CONDLOG.info(() -> "This DAO of class " + this.getClass().getName() + " will not be able to read from a file");
                file = null;
            } else {
                file = this.getSafeFile(string, IDAO.EMode.READ);
                CONDLOG.info(() -> "This DAO of class " + this.getClass().getName() + " is initially read from file ");
            }
            boolean bl = file == null || !file.exists();
            this.m_aRWLock.writeLock().lock();
            try {
                StopWatch stopWatch;
                Object object;
                this.m_bCanWriteWAL = false;
                IMicroDocument iMicroDocument = null;
                try {
                    object = ESuccess.SUCCESS;
                    if (bl) {
                        CONDLOG.info(() -> "Trying to initialize WAL DAO" + (String)(file == null ? "" : " XML file '" + file.getAbsolutePath() + "'"));
                        this.beginWithoutAutoSave();
                        try {
                            this.m_aStatsCounterInitTotal.increment();
                            stopWatch = StopWatch.createdStarted();
                            if (this.onInit().isChanged() && file != null) {
                                object = this._writeToFile();
                            }
                            this.m_aStatsCounterInitTimer.addTime(stopWatch.stopAndGetMillis());
                            this.m_aStatsCounterInitSuccess.increment();
                            ++this.m_nInitCount;
                            this.m_aLastInitDT = PDTFactory.getCurrentLocalDateTime();
                        }
                        finally {
                            this.endWithoutAutoSave();
                            this.internalSetPendingChanges(false);
                        }
                    }
                    CONDLOG.info(() -> "Trying to read WAL DAO XML file '" + file.getAbsolutePath() + "'");
                    this.m_aStatsCounterReadTotal.increment();
                    iMicroDocument = MicroReader.readMicroXML((File)file);
                    if (iMicroDocument == null) {
                        LOGGER.error("Failed to read DAO XML document from file '" + file.getAbsolutePath() + "'");
                    } else {
                        this.beginWithoutAutoSave();
                        try {
                            stopWatch = StopWatch.createdStarted();
                            if (this.onRead(iMicroDocument).isChanged()) {
                                object = this._writeToFile();
                            }
                            this.m_aStatsCounterReadTimer.addTime(stopWatch.stopAndGetMillis());
                            this.m_aStatsCounterReadSuccess.increment();
                            ++this.m_nReadCount;
                            this.m_aLastReadDT = PDTFactory.getCurrentLocalDateTime();
                        }
                        finally {
                            this.endWithoutAutoSave();
                            this.internalSetPendingChanges(false);
                        }
                    }
                    if (object.isSuccess()) {
                        this.internalSetPendingChanges(false);
                    } else {
                        LOGGER.error("File '" + file.getAbsolutePath() + "' has pending changes after initialRead!");
                    }
                }
                catch (Exception exception) {
                    AbstractWALDAO.triggerExceptionHandlersRead(exception, bl, file);
                    throw new DAOException("Error " + (bl ? "initializing" : "reading") + (String)(file == null ? "in-memory" : " the file '" + file.getAbsolutePath() + "'"), exception);
                }
                if (iMicroDocument != null) {
                    this.onBetweenReadAndWAL(iMicroDocument);
                }
                File file2 = stopWatch = (object = this._getWALFilename()) == null ? null : this.m_aIO.getFile((String)object);
                if (stopWatch == null || !stopWatch.exists()) break block49;
                CONDLOG.info(() -> AbstractWALDAO.lambda$initialRead$5((File)stopWatch));
                boolean bl2 = false;
                boolean bl3 = false;
                try (DataInputStream dataInputStream = new DataInputStream(FileHelper.getInputStream((File)stopWatch));){
                    block31: while (true) {
                        String string2;
                        try {
                            string2 = StreamHelper.readSafeUTF((DataInput)dataInputStream);
                        }
                        catch (EOFException eOFException) {
                            break;
                        }
                        EDAOActionType eDAOActionType = EDAOActionType.getFromIDOrThrow(string2);
                        int n = dataInputStream.readInt();
                        CONDLOG.info(() -> "Trying to recover " + n + " " + String.valueOf((Object)eDAOActionType) + " actions from WAL file");
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block31;
                            String string3 = StreamHelper.readSafeUTF((DataInput)dataInputStream);
                            Object DATATYPE = this.convertWALStringToNative(string3);
                            if (DATATYPE == null) {
                                bl3 = true;
                                this.onRecoveryErrorConvertToNative(eDAOActionType, n2, string3);
                            } else {
                                int n3 = n2;
                                CONDLOG.info(() -> "Trying to recover object [" + n3 + "] with " + string3.length() + " chars");
                                switch (eDAOActionType) {
                                    case CREATE: {
                                        try {
                                            this.onRecoveryCreate(DATATYPE);
                                            bl2 = true;
                                            CONDLOG.info(() -> "[WAL] wal-recovery create " + String.valueOf(DATATYPE));
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            LOGGER.error("[WAL] wal-recovery create " + String.valueOf(DATATYPE) + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            throw runtimeException;
                                        }
                                    }
                                    case UPDATE: {
                                        try {
                                            this.onRecoveryUpdate(DATATYPE);
                                            bl2 = true;
                                            CONDLOG.info(() -> "[WAL] wal-recovery update " + String.valueOf(DATATYPE));
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            LOGGER.error("[WAL] wal-recovery update " + String.valueOf(DATATYPE) + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            throw runtimeException;
                                        }
                                    }
                                    case DELETE: {
                                        try {
                                            this.onRecoveryDelete(DATATYPE);
                                            bl2 = true;
                                            CONDLOG.info(() -> "[WAL] wal-recovery delete " + String.valueOf(DATATYPE));
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            LOGGER.error("[WAL] wal-recovery delete " + String.valueOf(DATATYPE) + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            throw runtimeException;
                                        }
                                    }
                                    default: {
                                        String string4 = "Unsupported action type provided: " + String.valueOf((Object)eDAOActionType);
                                        LOGGER.error(string4);
                                        throw new IllegalStateException(string4);
                                    }
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                    CONDLOG.info(() -> AbstractWALDAO.lambda$initialRead$11((File)stopWatch));
                }
                catch (IOException | RuntimeException exception) {
                    LOGGER.error("Failed to recover from WAL file '" + stopWatch.getAbsolutePath() + "'. Technical details: " + exception.getClass().getName() + ": " + exception.getMessage());
                    AbstractWALDAO.triggerExceptionHandlersRead(exception, false, (File)stopWatch);
                    throw new DAOException("Error the WAL file '" + stopWatch.getAbsolutePath() + "'", exception);
                }
                if (bl2) {
                    this._writeToFileAndResetPendingChanges("onRecovery");
                }
                if (bl3) {
                    this._maintainWALFileAfterProcessing((String)object);
                } else {
                    this._deleteWALFileAfterProcessing((String)object);
                }
            }
            finally {
                this.m_bCanWriteWAL = true;
                this.m_aRWLock.writeLock().unlock();
            }
        }
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void onFilenameChange(@Nullable String string, @NonNull String string2) {
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected abstract @NonNull IMicroDocument createWriteData();

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void modifyWriteData(@NonNull IMicroDocument iMicroDocument) {
        CONDLOG.info(() -> "Inserting automatic 'do NOT modify' header to XML");
        MicroComment microComment = new MicroComment((CharSequence)("This file was generated automatically - do NOT modify!\nWritten at " + PDTToString.getAsString((ZonedDateTime)ZonedDateTime.now(Clock.systemUTC()), (Locale)Locale.US)));
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement != null) {
            iMicroDocument.insertBefore((IMicroNode)microComment, (IMicroNode)iMicroElement);
        } else {
            iMicroDocument.addChild((IMicroNode)microComment);
        }
    }

    @OverrideOnDemand
    protected @NonNull IXMLWriterSettings getXMLWriterSettings() {
        return WRITE_XWS;
    }

    public final @Nullable String getLastFilename() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sPreviousFilename);
    }

    protected static void triggerExceptionHandlersWrite(@NonNull Throwable throwable, @NonNull String string, @Nullable IMicroDocument iMicroDocument) {
        if (AbstractWALDAO.exceptionHandlersWrite().isNotEmpty()) {
            FileSystemResource fileSystemResource = new FileSystemResource(string);
            String string2 = iMicroDocument == null ? "no XML document created" : MicroWriter.getNodeAsString((IMicroNode)iMicroDocument);
            AbstractWALDAO.exceptionHandlersWrite().forEach(arg_0 -> AbstractWALDAO.lambda$triggerExceptionHandlersWrite$14(throwable, (IReadableResource)fileSystemResource, string2, arg_0));
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private @NonNull ESuccess _writeToFile() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            CONDLOG.info(() -> "The DAO of class " + this.getClass().getName() + " cannot write to a file");
            return ESuccess.FAILURE;
        }
        if (!string.equals(this.m_sPreviousFilename)) {
            this.onFilenameChange(this.m_sPreviousFilename, string);
            this.m_sPreviousFilename = string;
        }
        CONDLOG.info(() -> "Trying to write WAL DAO file '" + string + "'");
        File file = null;
        IMicroDocument iMicroDocument = null;
        String string2 = AbstractWALDAO._getFilenameNew(string);
        String string3 = AbstractWALDAO._getFilenamePrev(string);
        try {
            FileIOError fileIOError;
            file = this.getSafeFile(string2, IDAO.EMode.WRITE);
            this.m_aStatsCounterWriteTotal.increment();
            StopWatch stopWatch = StopWatch.createdStarted();
            CONDLOG.info(() -> "Creating XML file to write");
            iMicroDocument = this.createWriteData();
            if (iMicroDocument == null) {
                throw new DAOException("Failed to create data to write to file");
            }
            this.modifyWriteData(iMicroDocument);
            CONDLOG.info(() -> "Opening output stream of '" + string2 + "'");
            FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
            if (fileOutputStream == null) {
                throw new DAOException("Failed to open output stream for '" + file.getAbsolutePath() + "'");
            }
            IXMLWriterSettings iXMLWriterSettings = this.getXMLWriterSettings();
            CONDLOG.info(() -> "Now serializing XML to stream with XWS " + String.valueOf(iXMLWriterSettings));
            if (MicroWriter.writeToStream((IMicroNode)iMicroDocument, (OutputStream)fileOutputStream, (IXMLWriterSettings)iXMLWriterSettings).isFailure()) {
                throw new DAOException("Failed to write DAO XML data to file");
            }
            CONDLOG.info(() -> "Finished serializing XML to stream");
            boolean bl = false;
            if (this.m_aIO.existsFile(string)) {
                fileIOError = this.m_aIO.renameFile(string, string3);
                bl = true;
            } else {
                fileIOError = new FileIOError(EFileIOOperation.RENAME_FILE, EFileIOErrorCode.NO_ERROR);
            }
            if (fileIOError.isSuccess()) {
                fileIOError = this.m_aIO.renameFile(string2, string);
                if (fileIOError.isSuccess()) {
                    fileIOError = this.m_aIO.deleteFileIfExisting(string3);
                } else if (bl) {
                    this.m_aIO.renameFile(string3, string);
                }
            }
            if (fileIOError.isFailure()) {
                String string4 = "Error on rename(existing-old)/rename(new-existing)/delete(old): " + String.valueOf(fileIOError);
                LOGGER.error(string4);
                throw new IllegalStateException(string4);
            }
            this.m_aStatsCounterWriteTimer.addTime(stopWatch.stopAndGetMillis());
            this.m_aStatsCounterWriteSuccess.increment();
            ++this.m_nWriteCount;
            this.m_aLastWriteDT = PDTFactory.getCurrentLocalDateTime();
            return ESuccess.SUCCESS;
        }
        catch (DAOException | RuntimeException exception) {
            String string5 = file != null ? file.getAbsolutePath() : string;
            LOGGER.error("The DAO of class " + this.getClass().getName() + " failed to write the DAO data to '" + string5 + "'", (Throwable)exception);
            AbstractWALDAO.triggerExceptionHandlersWrite(exception, string5, iMicroDocument);
            this.m_aStatsCounterWriteExceptions.increment();
            return ESuccess.FAILURE;
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    final void _writeToFileAndResetPendingChanges(@NonNull String string) {
        if (this._writeToFile().isSuccess()) {
            this.internalSetPendingChanges(false);
        } else {
            LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after " + string + "!");
        }
    }

    private @Nullable String _getWALFilename() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            return null;
        }
        return string + ".wal";
    }

    final void _maintainWALFileAfterProcessing(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"WALFilename");
        File file = this.m_aIO.getFile(string);
        File file2 = new File(file.getParentFile(), file.getName() + "." + PDTFactory.getCurrentMillis() + ".bup");
        if (FileOperationManager.INSTANCE.renameFile(file, file2).isFailure()) {
            LOGGER.error("Failed to rename WAL file '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'");
        } else {
            CONDLOG.info(() -> "Maintained WAL file '" + file.getAbsolutePath() + "' as '" + file2.getAbsolutePath() + "' for debugging purposes");
        }
    }

    final void _deleteWALFileAfterProcessing(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"WALFilename");
        File file = this.m_aIO.getFile(string);
        if (FileOperationManager.INSTANCE.deleteFile(file).isFailure()) {
            LOGGER.error("Failed to delete WAL file '" + file.getAbsolutePath() + "'");
        } else {
            CONDLOG.info(() -> "Deleted successfully imported WAL file '" + file.getAbsolutePath() + "'");
        }
    }

    @OverrideOnDemand
    protected @NonNull IXMLWriterSettings getWALXMLWriterSettings() {
        return WAL_XWS;
    }

    @OverrideOnDemand
    protected @NonNull String convertNativeToWALString(@NonNull DATATYPE DATATYPE) {
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(DATATYPE, (String)"item");
        if (iMicroElement == null) {
            String string = "Failed to convert " + String.valueOf(DATATYPE) + " of class " + DATATYPE.getClass().getName() + " to XML!";
            LOGGER.error(string);
            throw new IllegalStateException(string);
        }
        return MicroWriter.getNodeAsString((IMicroNode)iMicroElement, (IXMLWriterSettings)this.getWALXMLWriterSettings());
    }

    @MustBeLocked(value=ELockType.WRITE)
    private @NonNull ESuccess _writeWALFile(@Nonempty @NonNull List<DATATYPE> list, @NonNull EDAOActionType eDAOActionType, @Nonempty @NonNull String string) {
        ESuccess eSuccess;
        FileSystemResource fileSystemResource = this.m_aIO.getResource(string);
        CONDLOG.info(() -> "Writing WAL file " + String.valueOf(fileSystemResource));
        DataOutputStream dataOutputStream = new DataOutputStream(fileSystemResource.getOutputStream(EAppend.APPEND));
        try {
            StreamHelper.writeSafeUTF((DataOutput)dataOutputStream, (String)eDAOActionType.getID());
            dataOutputStream.writeInt(list.size());
            for (DATATYPE DATATYPE : list) {
                String string2 = this.convertNativeToWALString(DATATYPE);
                StreamHelper.writeSafeUTF((DataOutput)dataOutputStream, (String)string2);
            }
            CONDLOG.info(() -> "Finished writing WAL file " + String.valueOf(fileSystemResource));
            eSuccess = ESuccess.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                LOGGER.error("Error writing WAL file " + String.valueOf(fileSystemResource), (Throwable)exception);
                AbstractWALDAO.triggerExceptionHandlersWrite(exception, string, null);
                return ESuccess.FAILURE;
            }
        }
        dataOutputStream.close();
        return eSuccess;
    }

    public @NonNull Duration getWaitingTime() {
        return this.m_aWaitingTime;
    }

    protected void setWaitingTime(@NonNull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"WaitingTime");
        this.m_aWaitingTime = duration;
        CONDLOG.info(() -> "Set WAL DAO waiting time to " + String.valueOf(duration));
    }

    @OverridingMethodsMustInvokeSuper
    @MustBeLocked(value=ELockType.WRITE)
    protected void markAsChanged(@NonNull DATATYPE DATATYPE, @NonNull EDAOActionType eDAOActionType) {
        ValueEnforcer.notNull(DATATYPE, (String)"ModifiedElement");
        ValueEnforcer.notNull((Object)((Object)eDAOActionType), (String)"ActionType");
        this.markAsChanged((List<DATATYPE>)new CommonsArrayList(DATATYPE), eDAOActionType);
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void markAsChanged(@NonNull List<DATATYPE> list, @NonNull EDAOActionType eDAOActionType) {
        ValueEnforcer.notNull(list, (String)"ModifiedElements");
        ValueEnforcer.notNull((Object)((Object)eDAOActionType), (String)"ActionType");
        CONDLOG.info(() -> "Now processing WAL DAO action " + String.valueOf((Object)eDAOActionType) + " for " + list.size() + " elements");
        this.internalSetPendingChanges(true);
        if (this.internalIsAutoSaveEnabled()) {
            String string = this._getWALFilename();
            if (this.m_bCanWriteWAL && this.m_aWaitingTime.compareTo(Duration.ZERO) > 0 && string != null && this._writeWALFile(list, eDAOActionType, string).isSuccess()) {
                this.m_aWALListener.registerForLaterWriting(this, string, this.m_aWaitingTime);
            } else {
                this._writeToFileAndResetPendingChanges("markAsChanged(" + eDAOActionType.getID() + ")");
            }
        }
    }

    @Override
    public final void writeToFileOnPendingChanges() {
        if (this.hasPendingChanges()) {
            this.m_aRWLock.writeLocked(() -> this._writeToFileAndResetPendingChanges("writeToFileOnPendingChanges"));
        }
    }

    @Override
    @Nonnegative
    public int getInitCount() {
        return this.m_nInitCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastInitDateTime() {
        return this.m_aLastInitDT;
    }

    @Override
    @Nonnegative
    public int getReadCount() {
        return this.m_nReadCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastReadDateTime() {
        return this.m_aLastReadDT;
    }

    @Override
    @Nonnegative
    public int getWriteCount() {
        return this.m_nWriteCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastWriteDateTime() {
        return this.m_aLastWriteDT;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DataTypeClass", this.m_aDataTypeClass).append("IO", (Object)this.m_aIO).append("FilenameProvider", this.m_aFilenameProvider).append("PreviousFilename", (Object)this.m_sPreviousFilename).append("InitCount", this.m_nInitCount).appendIfNotNull("LastInitDT", (Object)this.m_aLastInitDT).append("ReadCount", this.m_nReadCount).appendIfNotNull("LastReadDT", (Object)this.m_aLastReadDT).append("WriteCount", this.m_nWriteCount).appendIfNotNull("LastWriteDT", (Object)this.m_aLastWriteDT).append("CanWriteWAL", this.m_bCanWriteWAL).append("WaitingTime", (Object)this.m_aWaitingTime).getToString();
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersWrite$14(Throwable throwable, IReadableResource iReadableResource, String string, IDAOWriteExceptionCallback iDAOWriteExceptionCallback) {
        iDAOWriteExceptionCallback.onDAOWriteException(throwable, iReadableResource, string);
    }

    private static /* synthetic */ String lambda$initialRead$11(File file) {
        return "Successfully finished recovery from WAL file " + file.getAbsolutePath();
    }

    private static /* synthetic */ String lambda$initialRead$5(File file) {
        return "Trying to recover from WAL file " + file.getAbsolutePath();
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersRead$0(Throwable throwable, boolean bl, IReadableResource iReadableResource, IDAOReadExceptionCallback iDAOReadExceptionCallback) {
        iDAOReadExceptionCallback.onDAOReadException(throwable, bl, iReadableResource);
    }
}

