/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.simple;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.ESuccess;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.dao.AbstractDAO;
import com.helger.dao.DAOException;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import com.helger.io.relative.IFileRelativeIO;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSimpleDAO
extends AbstractDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimpleDAO.class);
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterInitTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$init"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterReadTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$read"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-success"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteExceptions = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-exceptions"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterWriteTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$write"));
    private final IFileRelativeIO m_aIO;
    private final Supplier<String> m_aFilenameProvider;
    private String m_sPreviousFilename;
    private int m_nInitCount = 0;
    private LocalDateTime m_aLastInitDT;
    private int m_nReadCount = 0;
    private LocalDateTime m_aLastReadDT;
    private int m_nWriteCount = 0;
    private LocalDateTime m_aLastWriteDT;

    protected AbstractSimpleDAO(@NonNull IFileRelativeIO iFileRelativeIO, @NonNull Supplier<String> supplier) {
        this.m_aIO = (IFileRelativeIO)ValueEnforcer.notNull((Object)iFileRelativeIO, (String)"IO");
        this.m_aFilenameProvider = (Supplier)ValueEnforcer.notNull(supplier, (String)"FilenameProvider");
    }

    protected final @NonNull IFileRelativeIO getIO() {
        return this.m_aIO;
    }

    public final @NonNull Supplier<String> getFilenameProvider() {
        return this.m_aFilenameProvider;
    }

    @OverrideOnDemand
    protected @NonNull EChange onInit() {
        return EChange.UNCHANGED;
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected abstract @NonNull EChange onRead(@NonNull IMicroDocument var1);

    protected final @NonNull File getSafeFile(@NonNull String string, @NonNull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)string, (String)"Filename");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        File file = this.m_aIO.getFile(string);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new DAOException("The passed filename '" + string + "' is not a file - maybe a directory? Path is '" + file.getAbsolutePath() + "'");
            }
            switch (eMode) {
                case READ: {
                    if (file.canRead()) break;
                    throw new DAOException("The DAO of class " + this.getClass().getName() + " has no access rights to read from '" + file.getAbsolutePath() + "'");
                }
                case WRITE: {
                    if (file.canWrite()) break;
                    throw new DAOException("The DAO of class " + this.getClass().getName() + " has no access rights to write to '" + file.getAbsolutePath() + "'");
                }
            }
        } else {
            FileIOError fileIOError;
            File file2 = file.getParentFile();
            if (file2 != null && (fileIOError = FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file2)).isFailure()) {
                throw new DAOException("The DAO of class " + this.getClass().getName() + " failed to create parent directory '" + String.valueOf(file2) + "': " + String.valueOf(fileIOError));
            }
        }
        return file;
    }

    protected static void triggerExceptionHandlersRead(@NonNull Throwable throwable, boolean bl, @Nullable File file) {
        if (AbstractSimpleDAO.exceptionHandlersRead().isNotEmpty()) {
            FileSystemResource fileSystemResource = file == null ? null : new FileSystemResource(file);
            AbstractSimpleDAO.exceptionHandlersRead().forEach(arg_0 -> AbstractSimpleDAO.lambda$triggerExceptionHandlersRead$0(throwable, bl, (IReadableResource)fileSystemResource, arg_0));
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void initialRead() throws DAOException {
        File file = null;
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            CONDLOG.info(() -> "This DAO of class " + this.getClass().getName() + " will not be able to read from a file");
        } else {
            file = this.getSafeFile(string, IDAO.EMode.READ);
        }
        File file2 = file;
        this.m_aRWLock.writeLockedThrowing(() -> {
            boolean bl = file2 == null || !file2.exists();
            try {
                ESuccess eSuccess = ESuccess.SUCCESS;
                if (bl) {
                    CONDLOG.info(() -> "Trying to initialize DAO XML file '" + String.valueOf(file2) + "'");
                    this.beginWithoutAutoSave();
                    try {
                        this.m_aStatsCounterInitTotal.increment();
                        StopWatch stopWatch = StopWatch.createdStarted();
                        if (this.onInit().isChanged() && file2 != null) {
                            eSuccess = this._writeToFile();
                        }
                        this.m_aStatsCounterInitTimer.addTime(stopWatch.stopAndGetMillis());
                        this.m_aStatsCounterInitSuccess.increment();
                        ++this.m_nInitCount;
                        this.m_aLastInitDT = PDTFactory.getCurrentLocalDateTime();
                    }
                    finally {
                        this.endWithoutAutoSave();
                        this.internalSetPendingChanges(false);
                    }
                }
                CONDLOG.info(() -> "Trying to read DAO XML file '" + String.valueOf(file2) + "'");
                this.m_aStatsCounterReadTotal.increment();
                IMicroDocument iMicroDocument = MicroReader.readMicroXML((File)file2);
                if (iMicroDocument == null) {
                    LOGGER.error("Failed to read XML document from file '" + String.valueOf(file2) + "'");
                } else {
                    this.beginWithoutAutoSave();
                    try {
                        StopWatch stopWatch = StopWatch.createdStarted();
                        if (this.onRead(iMicroDocument).isChanged()) {
                            eSuccess = this._writeToFile();
                        }
                        this.m_aStatsCounterReadTimer.addTime(stopWatch.stopAndGetMillis());
                        this.m_aStatsCounterReadSuccess.increment();
                        ++this.m_nReadCount;
                        this.m_aLastReadDT = PDTFactory.getCurrentLocalDateTime();
                    }
                    finally {
                        this.endWithoutAutoSave();
                        this.internalSetPendingChanges(false);
                    }
                }
                if (eSuccess.isSuccess()) {
                    this.internalSetPendingChanges(false);
                } else {
                    LOGGER.error("File '" + String.valueOf(file2) + "' has pending changes after initialRead!");
                }
            }
            catch (Exception exception) {
                AbstractSimpleDAO.triggerExceptionHandlersRead(exception, bl, file2);
                throw new DAOException("Error " + (bl ? "initializing" : "reading") + " the file '" + String.valueOf(file2) + "'", exception);
            }
        });
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void onFilenameChange(@Nullable String string, @NonNull String string2) {
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected abstract @NonNull IMicroDocument createWriteData();

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void modifyWriteData(@NonNull IMicroDocument iMicroDocument) {
        MicroComment microComment = new MicroComment((CharSequence)("This file was generated automatically - do NOT modify!\nWritten at " + PDTToString.getAsString((ZonedDateTime)ZonedDateTime.now(Clock.systemUTC()), (Locale)Locale.US)));
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement != null) {
            iMicroDocument.insertBefore((IMicroNode)microComment, (IMicroNode)iMicroElement);
        } else {
            iMicroDocument.addChild((IMicroNode)microComment);
        }
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void beforeWriteToFile(@NonNull String string, @NonNull File file) {
    }

    @OverrideOnDemand
    protected @NonNull IXMLWriterSettings getXMLWriterSettings() {
        return XMLWriterSettings.DEFAULT_XML_SETTINGS;
    }

    public final @Nullable String getLastFilename() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sPreviousFilename);
    }

    protected static void triggerExceptionHandlersWrite(@NonNull Throwable throwable, @NonNull String string, @Nullable IMicroDocument iMicroDocument) {
        if (AbstractSimpleDAO.exceptionHandlersWrite().isNotEmpty()) {
            FileSystemResource fileSystemResource = new FileSystemResource(string);
            String string2 = iMicroDocument == null ? "no XML document created" : MicroWriter.getNodeAsString((IMicroNode)iMicroDocument);
            AbstractSimpleDAO.exceptionHandlersWrite().forEach(arg_0 -> AbstractSimpleDAO.lambda$triggerExceptionHandlersWrite$6(throwable, (IReadableResource)fileSystemResource, string2, arg_0));
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private @NonNull ESuccess _writeToFile() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            CONDLOG.info(() -> "The DAO of class " + this.getClass().getName() + " cannot write to a file");
            return ESuccess.FAILURE;
        }
        if (!string.equals(this.m_sPreviousFilename)) {
            this.onFilenameChange(this.m_sPreviousFilename, string);
            this.m_sPreviousFilename = string;
        }
        CONDLOG.info(() -> "Trying to write DAO file '" + string + "'");
        File file = null;
        IMicroDocument iMicroDocument = null;
        try {
            file = this.getSafeFile(string, IDAO.EMode.WRITE);
            this.m_aStatsCounterWriteTotal.increment();
            StopWatch stopWatch = StopWatch.createdStarted();
            iMicroDocument = this.createWriteData();
            if (iMicroDocument == null) {
                throw new DAOException("Failed to create data to write to file");
            }
            this.modifyWriteData(iMicroDocument);
            this.beforeWriteToFile(string, file);
            FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
            if (fileOutputStream == null) {
                throw new DAOException("Failed to open output stream");
            }
            IXMLWriterSettings iXMLWriterSettings = this.getXMLWriterSettings();
            if (MicroWriter.writeToStream((IMicroNode)iMicroDocument, (OutputStream)fileOutputStream, (IXMLWriterSettings)iXMLWriterSettings).isFailure()) {
                throw new DAOException("Failed to write DAO XML data to file");
            }
            this.m_aStatsCounterWriteTimer.addTime(stopWatch.stopAndGetMillis());
            this.m_aStatsCounterWriteSuccess.increment();
            ++this.m_nWriteCount;
            this.m_aLastWriteDT = PDTFactory.getCurrentLocalDateTime();
            return ESuccess.SUCCESS;
        }
        catch (Exception exception) {
            String string2 = file != null ? file.getAbsolutePath() : string;
            LOGGER.error("The DAO of class " + this.getClass().getName() + " failed to write the DAO data to '" + string2 + "'", (Throwable)exception);
            AbstractSimpleDAO.triggerExceptionHandlersWrite(exception, string2, iMicroDocument);
            this.m_aStatsCounterWriteExceptions.increment();
            return ESuccess.FAILURE;
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void markAsChanged() {
        this.internalSetPendingChanges(true);
        if (this.internalIsAutoSaveEnabled()) {
            if (this._writeToFile().isSuccess()) {
                this.internalSetPendingChanges(false);
            } else {
                LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after markAsChanged!");
            }
        }
    }

    @Override
    public final void writeToFileOnPendingChanges() {
        if (this.hasPendingChanges()) {
            this.m_aRWLock.writeLocked(() -> {
                if (this._writeToFile().isSuccess()) {
                    this.internalSetPendingChanges(false);
                } else {
                    LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after writeToFileOnPendingChanges!");
                }
            });
        }
    }

    @Override
    @Nonnegative
    public int getInitCount() {
        return this.m_nInitCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastInitDateTime() {
        return this.m_aLastInitDT;
    }

    @Override
    @Nonnegative
    public int getReadCount() {
        return this.m_nReadCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastReadDateTime() {
        return this.m_aLastReadDT;
    }

    @Override
    @Nonnegative
    public int getWriteCount() {
        return this.m_nWriteCount;
    }

    @Override
    public final @Nullable LocalDateTime getLastWriteDateTime() {
        return this.m_aLastWriteDT;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("IO", (Object)this.m_aIO).append("FilenameProvider", this.m_aFilenameProvider).append("PreviousFilename", (Object)this.m_sPreviousFilename).append("InitCount", this.m_nInitCount).appendIfNotNull("LastInitDT", (Object)this.m_aLastInitDT).append("ReadCount", this.m_nReadCount).appendIfNotNull("LastReadDT", (Object)this.m_aLastReadDT).append("WriteCount", this.m_nWriteCount).appendIfNotNull("LastWriteDT", (Object)this.m_aLastWriteDT).getToString();
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersWrite$6(Throwable throwable, IReadableResource iReadableResource, String string, IDAOWriteExceptionCallback iDAOWriteExceptionCallback) {
        iDAOWriteExceptionCallback.onDAOWriteException(throwable, iReadableResource, string);
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersRead$0(Throwable throwable, boolean bl, IReadableResource iReadableResource, IDAOReadExceptionCallback iDAOReadExceptionCallback) {
        iDAOReadExceptionCallback.onDAOReadException(throwable, bl, iReadableResource);
    }
}

