/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao;

import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.dao.DAOException;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import java.io.File;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractDAO
implements IDAO,
IHasConditionalLogger {
    public static final boolean DEFAULT_AUTO_SAVE_ENABLED = true;
    public static final String FILENAME_EXTENSION_PREV = ".prev";
    public static final String FILENAME_EXTENSION_NEW = ".new";
    private static final CallbackList<IDAOReadExceptionCallback> EX_HANDLERS_READ = new CallbackList();
    private static final CallbackList<IDAOWriteExceptionCallback> EX_HANDLERS_WRITE = new CallbackList();
    protected static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDAO.class);
    protected static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final NonBlockingStack<Boolean> m_aAutoSaveStack = new NonBlockingStack();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bPendingChanges = false;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bAutoSaveEnabled = true;

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    protected AbstractDAO() {
    }

    @ReturnsMutableObject
    public static final @NonNull CallbackList<IDAOReadExceptionCallback> exceptionHandlersRead() {
        return EX_HANDLERS_READ;
    }

    @ReturnsMutableObject
    public static final @NonNull CallbackList<IDAOWriteExceptionCallback> exceptionHandlersWrite() {
        return EX_HANDLERS_WRITE;
    }

    @MustBeLocked(value=ELockType.READ)
    protected final boolean internalIsAutoSaveEnabled() {
        return this.m_bAutoSaveEnabled;
    }

    @Override
    public final boolean isAutoSaveEnabled() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bAutoSaveEnabled);
    }

    @MustBeLocked(value=ELockType.WRITE)
    public final void internalSetPendingChanges(boolean bl) {
        this.m_bPendingChanges = bl;
        CONDLOG.info(() -> "Pending changes now: " + bl);
    }

    @MustBeLocked(value=ELockType.READ)
    public final boolean internalHasPendingChanges() {
        return this.m_bPendingChanges;
    }

    @Override
    public final boolean hasPendingChanges() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bPendingChanges);
    }

    @Override
    public final void beginWithoutAutoSave() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aAutoSaveStack.push((Object)this.m_bAutoSaveEnabled);
            this.m_bAutoSaveEnabled = false;
            CONDLOG.info(() -> "Begin autosave");
        });
    }

    @Override
    public final void endWithoutAutoSave() {
        boolean bl = this.m_aRWLock.writeLockedBoolean(() -> {
            boolean bl;
            this.m_bAutoSaveEnabled = bl = ((Boolean)this.m_aAutoSaveStack.pop()).booleanValue();
            CONDLOG.info(() -> "End autosave");
            return bl;
        });
        if (bl) {
            this.writeToFileOnPendingChanges();
        }
    }

    protected static void checkFileAccess(@NonNull File file, @NonNull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)file, (String)"File");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        CONDLOG.debug(() -> "Checking file access for " + String.valueOf((Object)eMode) + " for file '" + file.getAbsolutePath() + "'");
        String string = file.toString();
        if (file.exists()) {
            if (!file.isFile()) {
                throw new DAOException("The passed filename '" + string + "' is not a file - maybe a directory or a symlink? Path is '" + file.getAbsolutePath() + "'");
            }
            switch (eMode) {
                case READ: {
                    if (file.canRead()) break;
                    throw new DAOException("Read access rights from '" + file.getAbsolutePath() + "' are missing.");
                }
                case WRITE: {
                    if (file.canWrite()) break;
                    throw new DAOException("Write access rights to '" + file.getAbsolutePath() + "' are missing");
                }
            }
        } else {
            FileIOError fileIOError;
            File file2 = file.getParentFile();
            if (file2 != null && (fileIOError = FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file2)).isFailure()) {
                throw new DAOException("Failed to create parent directory '" + String.valueOf(file2) + "' of '" + file.getAbsolutePath() + "': " + String.valueOf(fileIOError));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("autoSaveStack", this.m_aAutoSaveStack).append("pendingChanges", this.m_bPendingChanges).append("autoSaveEnabled", this.m_bAutoSaveEnabled).getToString();
    }
}

