/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.IThrowingSupplier;
import com.helger.base.iface.IThrowingRunnable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Supplier;

public interface IAutoSaveAware {
    public boolean isAutoSaveEnabled();

    public void beginWithoutAutoSave();

    public void endWithoutAutoSave();

    default public void performWithoutAutoSave(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull((Object)runnable, (String)"Runnable");
        this.beginWithoutAutoSave();
        try {
            runnable.run();
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    @Nullable
    default public <RETURNTYPE> RETURNTYPE performWithoutAutoSave(@Nonnull Supplier<RETURNTYPE> supplier) {
        ValueEnforcer.notNull(supplier, (String)"Callable");
        this.beginWithoutAutoSave();
        try {
            RETURNTYPE RETURNTYPE = supplier.get();
            return RETURNTYPE;
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    default public <EXTYPE extends Exception> void performWithoutAutoSaveThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, (String)"Runnable");
        this.beginWithoutAutoSave();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.endWithoutAutoSave();
        }
    }

    @Nullable
    default public <RETURNTYPE, EXTYPE extends Exception> RETURNTYPE performWithoutAutoSaveThrowing(@Nonnull IThrowingSupplier<RETURNTYPE, EXTYPE> iThrowingSupplier) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingSupplier, (String)"Callable");
        this.beginWithoutAutoSave();
        try {
            Object object = iThrowingSupplier.get();
            return (RETURNTYPE)object;
        }
        finally {
            this.endWithoutAutoSave();
        }
    }
}

