/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.container;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.IDAO;
import com.helger.dao.container.AbstractDAOContainer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;

public class DefaultDAOContainer
extends AbstractDAOContainer {
    private final ICommonsList<IDAO> m_aDAOs;

    public DefaultDAOContainer(IDAO ... iDAOArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iDAOArray, (String)"DAOs");
        this.m_aDAOs = new CommonsArrayList((Object[])iDAOArray);
    }

    public DefaultDAOContainer(@Nonnull @Nonempty Iterable<? extends IDAO> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"DAOs");
        this.m_aDAOs = new CommonsArrayList(iterable);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDAO> getAllContainedDAOs() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aDAOs.getClone());
    }

    @Override
    public boolean containsAny(@Nullable Predicate<? super IDAO> predicate) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aDAOs.containsAny(predicate));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DAOs", this.m_aDAOs).getToString();
    }
}

