/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.wal;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.dao.wal.AbstractWALDAO;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WALListener
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(WALListener.class);
    private final ScheduledExecutorService m_aES = Executors.newSingleThreadScheduledExecutor((ThreadFactory)BasicThreadFactory.builder().namingPattern("WAL-Listener-%d").build());
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aWaitingDAOs = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, WALItem> m_aScheduledItems = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public WALListener() {
    }

    @Nonnull
    public static WALListener getInstance() {
        return (WALListener)WALListener.getGlobalSingleton(WALListener.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        this.m_aRWLock.writeLocked(() -> {
            for (Map.Entry entry : this.m_aScheduledItems.entrySet()) {
                WALItem wALItem = (WALItem)entry.getValue();
                if (wALItem.m_aFuture.cancel(false)) {
                    this.m_aES.submit(wALItem.m_aRunnable);
                    LOGGER.info("Rescheduled DAO writing for " + (String)entry.getKey() + " to happen now");
                    continue;
                }
                LOGGER.info("Cannot reschedule DAO writing for " + (String)entry.getKey() + " because it is already running");
            }
            this.m_aScheduledItems.clear();
        });
        int n = this.m_aRWLock.readLockedInt(() -> this.m_aWaitingDAOs.size());
        if (n > 0) {
            LOGGER.info("Waiting for all remaining " + n + " DAO writing to be finalized");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Shutting down the ExecutorService");
        }
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aES);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("All DAO writing is now finalized");
        }
    }

    public void registerForLaterWriting(@Nonnull AbstractWALDAO<?> abstractWALDAO, @Nonnull String string, @Nonnull Duration duration) {
        String string2 = abstractWALDAO.getClass().getName() + "::" + string;
        boolean bl = this.m_aRWLock.writeLockedBoolean(() -> this.m_aWaitingDAOs.add((Object)string2));
        if (bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Now scheduling writing for DAO " + string2);
            }
            Runnable runnable = () -> {
                abstractWALDAO.internalWriteLocked(() -> {
                    abstractWALDAO._writeToFileAndResetPendingChanges("ScheduledWriter.run");
                    abstractWALDAO._deleteWALFileAfterProcessing(string);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Finished scheduled writing for DAO " + string2);
                    }
                });
                this.m_aRWLock.writeLocked(() -> {
                    this.m_aWaitingDAOs.remove((Object)string2);
                    this.m_aScheduledItems.remove((Object)string2);
                });
            };
            try {
                ScheduledFuture<?> scheduledFuture = this.m_aES.schedule(runnable, duration.toMillis(), TimeUnit.MILLISECONDS);
                this.m_aRWLock.writeLocked(() -> this.m_aScheduledItems.put((Object)string2, (Object)new WALItem(scheduledFuture, runnable)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LOGGER.error("Failed to schedule task - most likely because the ExecutorService is already shutting down. Running it now.", (Throwable)rejectedExecutionException);
                runnable.run();
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No need to schedule writing of DAO " + string2 + " because it is already scheduled");
        }
    }

    @Immutable
    private static final class WALItem {
        private final ScheduledFuture<?> m_aFuture;
        private final Runnable m_aRunnable;

        public WALItem(@Nonnull ScheduledFuture<?> scheduledFuture, @Nonnull Runnable runnable) {
            this.m_aFuture = scheduledFuture;
            this.m_aRunnable = runnable;
        }
    }
}

