/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.container;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.dao.IDAO;
import com.helger.dao.container.IDAOContainer;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractDAOContainer
implements IDAOContainer {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isAutoSaveEnabled() {
        return this.m_aRWLock.readLockedBoolean(() -> this.containsAny(iDAO -> iDAO != null && iDAO.isAutoSaveEnabled()));
    }

    @Override
    public final void beginWithoutAutoSave() {
        ICommonsList<IDAO> iCommonsList = this.getAllContainedDAOs();
        this.m_aRWLock.writeLocked(() -> {
            for (IDAO iDAO : iCommonsList) {
                if (iDAO == null) continue;
                iDAO.beginWithoutAutoSave();
            }
        });
    }

    @Override
    public final void endWithoutAutoSave() {
        ICommonsList<IDAO> iCommonsList = this.getAllContainedDAOs();
        this.m_aRWLock.writeLocked(() -> {
            for (IDAO iDAO : iCommonsList) {
                if (iDAO == null) continue;
                iDAO.endWithoutAutoSave();
            }
        });
    }
}

