/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.simple;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.dao.AbstractDAO;
import com.helger.dao.DAOException;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSimpleDAO
extends AbstractDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimpleDAO.class);
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterInitTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$init"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterReadTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$read"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-success"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteExceptions = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-exceptions"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterWriteTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$write"));
    private final IFileRelativeIO m_aIO;
    private final Supplier<String> m_aFilenameProvider;
    private String m_sPreviousFilename;
    private int m_nInitCount = 0;
    private LocalDateTime m_aLastInitDT;
    private int m_nReadCount = 0;
    private LocalDateTime m_aLastReadDT;
    private int m_nWriteCount = 0;
    private LocalDateTime m_aLastWriteDT;

    protected AbstractSimpleDAO(@Nonnull IFileRelativeIO iFileRelativeIO, @Nonnull Supplier<String> supplier) {
        this.m_aIO = (IFileRelativeIO)ValueEnforcer.notNull((Object)iFileRelativeIO, (String)"IO");
        this.m_aFilenameProvider = (Supplier)ValueEnforcer.notNull(supplier, (String)"FilenameProvider");
    }

    @Nonnull
    protected final IFileRelativeIO getIO() {
        return this.m_aIO;
    }

    @Nonnull
    public final Supplier<String> getFilenameProvider() {
        return this.m_aFilenameProvider;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onInit() {
        return EChange.UNCHANGED;
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected abstract EChange onRead(@Nonnull IMicroDocument var1);

    @Nonnull
    protected final File getSafeFile(@Nonnull String string, @Nonnull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)string, (String)"Filename");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        File file = this.m_aIO.getFile(string);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new DAOException("The passed filename '" + string + "' is not a file - maybe a directory? Path is '" + file.getAbsolutePath() + "'");
            }
            switch (eMode) {
                case READ: {
                    if (file.canRead()) break;
                    throw new DAOException("The DAO of class " + this.getClass().getName() + " has no access rights to read from '" + file.getAbsolutePath() + "'");
                }
                case WRITE: {
                    if (file.canWrite()) break;
                    throw new DAOException("The DAO of class " + this.getClass().getName() + " has no access rights to write to '" + file.getAbsolutePath() + "'");
                }
            }
        } else {
            FileIOError fileIOError;
            File file2 = file.getParentFile();
            if (file2 != null && (fileIOError = FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file2)).isFailure()) {
                throw new DAOException("The DAO of class " + this.getClass().getName() + " failed to create parent directory '" + file2 + "': " + fileIOError);
            }
        }
        return file;
    }

    protected static void triggerExceptionHandlersRead(@Nonnull Throwable throwable, boolean bl, @Nullable File file) {
        if (AbstractSimpleDAO.exceptionHandlersRead().isNotEmpty()) {
            FileSystemResource fileSystemResource = file == null ? null : new FileSystemResource(file);
            AbstractSimpleDAO.exceptionHandlersRead().forEach(arg_0 -> AbstractSimpleDAO.lambda$triggerExceptionHandlersRead$0(throwable, bl, (IReadableResource)fileSystemResource, arg_0));
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void initialRead() throws DAOException {
        File file = null;
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            if (!AbstractSimpleDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("This DAO of class " + this.getClass().getName() + " will not be able to read from a file");
            }
        } else {
            file = this.getSafeFile(string, IDAO.EMode.READ);
        }
        File file2 = file;
        this.m_aRWLock.writeLockedThrowing(() -> {
            boolean bl = file2 == null || !file2.exists();
            try {
                ESuccess eSuccess = ESuccess.SUCCESS;
                if (bl) {
                    if (!AbstractSimpleDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Trying to initialize DAO XML file '" + file2 + "'");
                    }
                    this.beginWithoutAutoSave();
                    try {
                        this.m_aStatsCounterInitTotal.increment();
                        StopWatch stopWatch = StopWatch.createdStarted();
                        if (this.onInit().isChanged() && file2 != null) {
                            eSuccess = this._writeToFile();
                        }
                        this.m_aStatsCounterInitTimer.addTime(stopWatch.stopAndGetMillis());
                        this.m_aStatsCounterInitSuccess.increment();
                        ++this.m_nInitCount;
                        this.m_aLastInitDT = PDTFactory.getCurrentLocalDateTime();
                    }
                    finally {
                        this.endWithoutAutoSave();
                        this.internalSetPendingChanges(false);
                    }
                }
                if (!AbstractSimpleDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Trying to read DAO XML file '" + file2 + "'");
                }
                this.m_aStatsCounterReadTotal.increment();
                IMicroDocument iMicroDocument = MicroReader.readMicroXML((File)file2);
                if (iMicroDocument == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to read XML document from file '" + file2 + "'");
                    }
                } else {
                    this.beginWithoutAutoSave();
                    try {
                        StopWatch stopWatch = StopWatch.createdStarted();
                        if (this.onRead(iMicroDocument).isChanged()) {
                            eSuccess = this._writeToFile();
                        }
                        this.m_aStatsCounterReadTimer.addTime(stopWatch.stopAndGetMillis());
                        this.m_aStatsCounterReadSuccess.increment();
                        ++this.m_nReadCount;
                        this.m_aLastReadDT = PDTFactory.getCurrentLocalDateTime();
                    }
                    finally {
                        this.endWithoutAutoSave();
                        this.internalSetPendingChanges(false);
                    }
                }
                if (eSuccess.isSuccess()) {
                    this.internalSetPendingChanges(false);
                } else if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("File '" + file2 + "' has pending changes after initialRead!");
                }
            }
            catch (Exception exception) {
                AbstractSimpleDAO.triggerExceptionHandlersRead(exception, bl, file2);
                throw new DAOException("Error " + (bl ? "initializing" : "reading") + " the file '" + file2 + "'", exception);
            }
        });
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void onFilenameChange(@Nullable String string, @Nonnull String string2) {
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected abstract IMicroDocument createWriteData();

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void modifyWriteData(@Nonnull IMicroDocument iMicroDocument) {
        MicroComment microComment = new MicroComment((CharSequence)("This file was generated automatically - do NOT modify!\nWritten at " + PDTToString.getAsString((ZonedDateTime)ZonedDateTime.now(Clock.systemUTC()), (Locale)Locale.US)));
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement != null) {
            iMicroDocument.insertBefore((IMicroNode)microComment, (IMicroNode)iMicroElement);
        } else {
            iMicroDocument.appendChild((IMicroNode)microComment);
        }
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void beforeWriteToFile(@Nonnull String string, @Nonnull File file) {
    }

    @Nonnull
    @OverrideOnDemand
    protected IXMLWriterSettings getXMLWriterSettings() {
        return XMLWriterSettings.DEFAULT_XML_SETTINGS;
    }

    @Nullable
    public final String getLastFilename() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sPreviousFilename);
    }

    protected static void triggerExceptionHandlersWrite(@Nonnull Throwable throwable, @Nonnull String string, @Nullable IMicroDocument iMicroDocument) {
        if (AbstractSimpleDAO.exceptionHandlersWrite().isNotEmpty()) {
            FileSystemResource fileSystemResource = new FileSystemResource(string);
            String string2 = iMicroDocument == null ? "no XML document created" : MicroWriter.getNodeAsString((IMicroNode)iMicroDocument);
            AbstractSimpleDAO.exceptionHandlersWrite().forEach(arg_0 -> AbstractSimpleDAO.lambda$triggerExceptionHandlersWrite$3(throwable, (IReadableResource)fileSystemResource, string2, arg_0));
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @MustBeLocked(value=ELockType.WRITE)
    private ESuccess _writeToFile() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            if (!AbstractSimpleDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("The DAO of class " + this.getClass().getName() + " cannot write to a file");
            }
            return ESuccess.FAILURE;
        }
        if (!string.equals(this.m_sPreviousFilename)) {
            this.onFilenameChange(this.m_sPreviousFilename, string);
            this.m_sPreviousFilename = string;
        }
        if (!AbstractSimpleDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Trying to write DAO file '" + string + "'");
        }
        File file = null;
        IMicroDocument iMicroDocument = null;
        try {
            file = this.getSafeFile(string, IDAO.EMode.WRITE);
            this.m_aStatsCounterWriteTotal.increment();
            StopWatch stopWatch = StopWatch.createdStarted();
            iMicroDocument = this.createWriteData();
            if (iMicroDocument == null) {
                throw new DAOException("Failed to create data to write to file");
            }
            this.modifyWriteData(iMicroDocument);
            this.beforeWriteToFile(string, file);
            FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
            if (fileOutputStream == null) {
                throw new DAOException("Failed to open output stream");
            }
            IXMLWriterSettings iXMLWriterSettings = this.getXMLWriterSettings();
            if (MicroWriter.writeToStream((IMicroNode)iMicroDocument, (OutputStream)fileOutputStream, (IXMLWriterSettings)iXMLWriterSettings).isFailure()) {
                throw new DAOException("Failed to write DAO XML data to file");
            }
            this.m_aStatsCounterWriteTimer.addTime(stopWatch.stopAndGetMillis());
            this.m_aStatsCounterWriteSuccess.increment();
            ++this.m_nWriteCount;
            this.m_aLastWriteDT = PDTFactory.getCurrentLocalDateTime();
            return ESuccess.SUCCESS;
        }
        catch (Exception exception) {
            String string2;
            String string3 = string2 = file != null ? file.getAbsolutePath() : string;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The DAO of class " + this.getClass().getName() + " failed to write the DAO data to '" + string2 + "'", (Throwable)exception);
            }
            AbstractSimpleDAO.triggerExceptionHandlersWrite(exception, string2, iMicroDocument);
            this.m_aStatsCounterWriteExceptions.increment();
            return ESuccess.FAILURE;
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void markAsChanged() {
        this.internalSetPendingChanges(true);
        if (this.internalIsAutoSaveEnabled()) {
            if (this._writeToFile().isSuccess()) {
                this.internalSetPendingChanges(false);
            } else if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after markAsChanged!");
            }
        }
    }

    @Override
    public final void writeToFileOnPendingChanges() {
        if (this.hasPendingChanges()) {
            this.m_aRWLock.writeLocked(() -> {
                if (this._writeToFile().isSuccess()) {
                    this.internalSetPendingChanges(false);
                } else if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after writeToFileOnPendingChanges!");
                }
            });
        }
    }

    @Override
    @Nonnegative
    public int getInitCount() {
        return this.m_nInitCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastInitDateTime() {
        return this.m_aLastInitDT;
    }

    @Override
    @Nonnegative
    public int getReadCount() {
        return this.m_nReadCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastReadDateTime() {
        return this.m_aLastReadDT;
    }

    @Override
    @Nonnegative
    public int getWriteCount() {
        return this.m_nWriteCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastWriteDateTime() {
        return this.m_aLastWriteDT;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("filenameProvider", this.m_aFilenameProvider).append("previousFilename", (Object)this.m_sPreviousFilename).append("initCount", this.m_nInitCount).appendIfNotNull("lastInitDT", (Object)this.m_aLastInitDT).append("readCount", this.m_nReadCount).appendIfNotNull("lastReadDT", (Object)this.m_aLastReadDT).append("writeCount", this.m_nWriteCount).appendIfNotNull("lastWriteDT", (Object)this.m_aLastWriteDT).getToString();
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersWrite$3(Throwable throwable, IReadableResource iReadableResource, String string, IDAOWriteExceptionCallback iDAOWriteExceptionCallback) {
        iDAOWriteExceptionCallback.onDAOWriteException(throwable, iReadableResource, string);
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersRead$0(Throwable throwable, boolean bl, IReadableResource iReadableResource, IDAOReadExceptionCallback iDAOReadExceptionCallback) {
        iDAOReadExceptionCallback.onDAOReadException(throwable, bl, iReadableResource);
    }
}

