/*
 * Decompiled with CFR 0.152.
 */
package com.helger.csv;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillCloseWhenClosed;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.iterator.ArrayIterator;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CSVWriter
implements Closeable,
Flushable {
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final boolean DEFAULT_QUOTE_ALL = true;
    public static final boolean DEFAULT_AVOID_FINAL_LINE_END = false;
    private final Writer m_aRawWriter;
    private final PrintWriter m_aPW;
    private int m_nWrittenLines = 0;
    private char m_cSeparatorChar = (char)44;
    private char m_cQuoteChar = (char)34;
    private char m_cEscapeChar = (char)92;
    private String m_sLineEnd = "\n";
    private boolean m_bAvoidFinalLineEnd = false;
    private boolean m_bApplyQuotesToAll = true;

    public CSVWriter(@WillCloseWhenClosed @NonNull Writer writer) {
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        this.m_aRawWriter = writer;
        this.m_aPW = new PrintWriter(writer);
    }

    public char getSeparatorChar() {
        return this.m_cSeparatorChar;
    }

    public @NonNull CSVWriter setSeparatorChar(char c) {
        if (c == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.m_cSeparatorChar = c;
        return this;
    }

    public char getQuoteChar() {
        return this.m_cQuoteChar;
    }

    public @NonNull CSVWriter setQuoteChar(char c) {
        this.m_cQuoteChar = c;
        return this;
    }

    public char getEscapeChar() {
        return this.m_cEscapeChar;
    }

    public @NonNull CSVWriter setEscapeChar(char c) {
        this.m_cEscapeChar = c;
        return this;
    }

    public @NonNull @Nonempty String getLineEnd() {
        return this.m_sLineEnd;
    }

    public @NonNull CSVWriter setLineEnd(@NonNull @Nonempty String string) {
        ValueEnforcer.notNull((Object)string, (String)"LineEnd");
        this.m_sLineEnd = string;
        return this;
    }

    public boolean isAvoidFinalLineEnd() {
        return this.m_bAvoidFinalLineEnd;
    }

    public @NonNull CSVWriter setAvoidFinalLineEnd(boolean bl) {
        this.m_bAvoidFinalLineEnd = bl;
        return this;
    }

    public boolean isApplyQuotesToAll() {
        return this.m_bApplyQuotesToAll;
    }

    public @NonNull CSVWriter setApplyQuotesToAll(boolean bl) {
        this.m_bApplyQuotesToAll = bl;
        return this;
    }

    public void writeAll(@NonNull List<? extends List<String>> list, boolean bl) {
        for (List<String> list2 : list) {
            this.writeNext(list2, bl);
        }
    }

    public void writeAll(@NonNull List<? extends List<String>> list) {
        this.writeAll(list, this.m_bApplyQuotesToAll);
    }

    public void writeNext(@Nullable Iterator<String> iterator, boolean bl) {
        if (iterator != null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            if (this.m_bAvoidFinalLineEnd && this.m_nWrittenLines > 0) {
                stringBuilder.append(this.m_sLineEnd);
            }
            boolean bl2 = this.m_cQuoteChar != '\u0000';
            boolean bl3 = true;
            while (iterator.hasNext()) {
                boolean bl4;
                String string;
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(this.m_cSeparatorChar);
                }
                if ((string = iterator.next()) == null) continue;
                boolean bl5 = this.stringContainsSpecialCharacters(string);
                boolean bl6 = bl4 = bl2 && (bl || bl5);
                if (bl4) {
                    stringBuilder.append(this.m_cQuoteChar);
                }
                if (bl5) {
                    stringBuilder.append((CharSequence)this.getEscapedText(string));
                } else {
                    stringBuilder.append(string);
                }
                if (!bl4) continue;
                stringBuilder.append(this.m_cQuoteChar);
            }
            if (!this.m_bAvoidFinalLineEnd) {
                stringBuilder.append(this.m_sLineEnd);
            }
            this.m_aPW.write(stringBuilder.toString());
            ++this.m_nWrittenLines;
        }
    }

    public void writeNext(@Nullable Iterable<String> iterable, boolean bl) {
        if (iterable != null) {
            this.writeNext(iterable.iterator(), bl);
        }
    }

    public void writeNext(@Nullable Iterable<String> iterable) {
        this.writeNext(iterable, this.m_bApplyQuotesToAll);
    }

    public void writeNext(@Nullable String[] stringArray, boolean bl) {
        if (stringArray != null) {
            this.writeNext(new ArrayIterator((Object[])stringArray).iterator(), bl);
        }
    }

    public void writeNext(String ... stringArray) {
        this.writeNext(stringArray, this.m_bApplyQuotesToAll);
    }

    public void writeNext(@Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        if (stringArray != null) {
            this.writeNext(new ArrayIterator((Object[])stringArray, n, n2).iterator(), bl);
        }
    }

    public void writeNext(@Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        this.writeNext(stringArray, n, n2, this.m_bApplyQuotesToAll);
    }

    protected boolean stringContainsSpecialCharacters(@NonNull String string) {
        return string.indexOf(this.m_cQuoteChar) != -1 || string.indexOf(this.m_cEscapeChar) != -1 || string.indexOf(this.m_cSeparatorChar) != -1 || string.indexOf(13) != -1 || string.indexOf(10) != -1;
    }

    protected @NonNull StringBuilder getEscapedText(@NonNull String string) {
        if (this.m_cEscapeChar == '\u0000') {
            return new StringBuilder(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == this.m_cQuoteChar || c == this.m_cEscapeChar) {
                stringBuilder.append(this.m_cEscapeChar);
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    @Override
    public void flush() throws IOException {
        this.m_aPW.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_aPW.close();
        this.m_aRawWriter.close();
    }

    public boolean checkError() {
        return this.m_aPW.checkError();
    }

    @Nonnegative
    public int getWrittenLines() {
        return this.m_nWrittenLines;
    }

    public void flushQuietly() {
        StreamHelper.flush((Flushable)this);
    }
}

