/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.resource.type;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.config.source.resource.AbstractConfigurationSourceResource;
import com.helger.config.source.resource.type.IConfigurationSourceResourceTypeRegistrarSPI;
import com.helger.io.resource.IReadableResource;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConfigurationSourceResourceTypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceResourceTypeRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Function<IReadableResource, AbstractConfigurationSourceResource>> m_aMap = new CommonsHashMap();

    private ConfigurationSourceResourceTypeRegistry() {
        this._reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull ConfigurationSourceResourceTypeRegistry getInstance() {
        ConfigurationSourceResourceTypeRegistry configurationSourceResourceTypeRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return configurationSourceResourceTypeRegistry;
    }

    private void _reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            for (IConfigurationSourceResourceTypeRegistrarSPI iConfigurationSourceResourceTypeRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IConfigurationSourceResourceTypeRegistrarSPI.class)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling registerResourceType on " + iConfigurationSourceResourceTypeRegistrarSPI.getClass().getName());
                }
                iConfigurationSourceResourceTypeRegistrarSPI.registerResourceType(this);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.m_aMap.size() + " resource types are registered");
            }
        });
    }

    public void register(@NonNull @Nonempty String string, @NonNull Function<IReadableResource, AbstractConfigurationSourceResource> function) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FileExt");
        ValueEnforcer.isFalse(() -> string.startsWith("."), () -> "The file extension '" + string + "' must not start with a dot");
        ValueEnforcer.notNull(function, (String)"Factory");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)string)) {
                throw new IllegalStateException("The configuration source file extension '" + string + "' is already registered");
            }
            this.m_aMap.put((Object)string, (Object)function);
        });
    }

    public @Nullable Function<IReadableResource, AbstractConfigurationSourceResource> getFactoryOfFileExtension(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (Function)this.m_aRWLock.readLockedGet(() -> (Function)this.m_aMap.get((Object)string));
    }

    public @NonNull Function<IReadableResource, AbstractConfigurationSourceResource> getFactoryOfFileExtensionOrFallback(@Nullable String string, @Nullable String string2) {
        Function<IReadableResource, AbstractConfigurationSourceResource> function = this.getFactoryOfFileExtension(string);
        if (function == null) {
            function = this.getFactoryOfFileExtension(string2);
        }
        if (function == null) {
            throw new IllegalStateException("Failed to resolve factory for '" + string + "' and '" + string2 + "'");
        }
        return function;
    }

    public void reinitialize() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitializing " + this.getClass().getName());
        }
        this._reinitialize();
    }

    private static final class SingletonHolder {
        private static final ConfigurationSourceResourceTypeRegistry INSTANCE = new ConfigurationSourceResourceTypeRegistry();

        private SingletonHolder() {
        }
    }
}

