/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.envvar;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IIterableConfigurationSource;
import com.helger.config.source.envvar.EnvVarHelper;
import com.helger.config.value.ConfiguredValue;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConfigurationSourceEnvVar
extends AbstractConfigurationSource
implements IIterableConfigurationSource {
    public static final EConfigSourceType SOURCE_TYPE = EConfigSourceType.ENVIRONMENT_VARIABLE;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceEnvVar.class);

    public ConfigurationSourceEnvVar() {
        this(SOURCE_TYPE.getDefaultPriority());
    }

    public ConfigurationSourceEnvVar(int n) {
        super(SOURCE_TYPE, n);
    }

    @Override
    public boolean isInitializedAndUsable() {
        return true;
    }

    @Override
    public @Nullable ConfiguredValue getConfigurationValue(@NonNull @Nonempty String string) {
        String string2 = EnvVarHelper.getUnifiedSysEnvName(string, '_');
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Querying configuration property '" + string + "' as EnvVar '" + string2 + "'");
        }
        String string3 = null;
        try {
            string3 = System.getenv(string2);
        }
        catch (SecurityException securityException) {
            LOGGER.error("Security violation accessing environment variable '" + string2 + "'", (Throwable)securityException);
        }
        if (string3 == null) {
            return null;
        }
        if (ConfigurationSourceEnvVar.hasTrailingWhitespace(string3)) {
            LOGGER.warn("The value of the environment variable '" + string2 + "' has a trailing whitespace. This may lead to unintended side effects.");
        }
        return new ConfiguredValue(this, string3);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, String> getAllConfigItems() {
        return new CommonsTreeMap(System.getenv());
    }
}

