/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.res;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.lang.PropertiesHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.res.AbstractConfigurationSourceResource;
import com.helger.config.value.ConfiguredValue;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigurationSourceProperties
extends AbstractConfigurationSourceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceProperties.class);
    private final Charset m_aCharset;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private NonBlockingProperties m_aProps;

    @Nullable
    private static NonBlockingProperties _load(@Nonnull IReadableResource iReadableResource, @Nullable Charset charset) {
        if (charset == null) {
            return PropertiesHelper.loadProperties((IReadableResource)iReadableResource);
        }
        return PropertiesHelper.loadProperties((IReadableResource)iReadableResource, (Charset)charset);
    }

    public ConfigurationSourceProperties(@Nonnull IReadableResource iReadableResource) {
        this(SOURCE_TYPE.getDefaultPriority(), iReadableResource, null);
    }

    public ConfigurationSourceProperties(@Nonnull IReadableResource iReadableResource, @Nullable Charset charset) {
        this(SOURCE_TYPE.getDefaultPriority(), iReadableResource, charset);
    }

    public ConfigurationSourceProperties(int n, @Nonnull IReadableResource iReadableResource) {
        this(n, iReadableResource, null);
    }

    public ConfigurationSourceProperties(int n, @Nonnull IReadableResource iReadableResource, @Nullable Charset charset) {
        super(n, iReadableResource);
        this.m_aCharset = charset;
        this.m_aProps = ConfigurationSourceProperties._load(iReadableResource, charset);
        if (this.m_aProps != null) {
            for (Map.Entry entry : this.m_aProps.entrySet()) {
                if (!ConfigurationSourceProperties.hasTrailingWhitespace((String)entry.getValue())) continue;
                LOGGER.warn("The value of the configuration property '" + (String)entry.getKey() + "' has a trailing whitespace. This may lead to unintended side effects.");
            }
        }
    }

    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public boolean isInitializedAndUsable() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aProps != null);
    }

    @Override
    @Nonnull
    public ESuccess reload() {
        NonBlockingProperties nonBlockingProperties = ConfigurationSourceProperties._load(this.getResource(), this.m_aCharset);
        this.m_aRWLock.writeLocked(() -> {
            this.m_aProps = nonBlockingProperties;
        });
        return ESuccess.valueOf((nonBlockingProperties != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        String string2 = (String)this.m_aRWLock.readLockedGet(() -> this.m_aProps == null ? null : (String)this.m_aProps.get((Object)string));
        return string2 == null ? null : new ConfiguredValue(this, string2);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllConfigItems() {
        return (ICommonsOrderedMap)this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashMap((Map)this.m_aProps));
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Properties", (Object)ConfigurationSourceProperties.mapToStringNoSecrets(this.m_aProps)).getToString();
    }
}

