/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.appl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.value.ConfiguredValue;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConfigurationSourceFunction
extends AbstractConfigurationSource {
    public static final EConfigSourceType SOURCE_TYPE = EConfigSourceType.APPLICATION;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceFunction.class);
    private final UnaryOperator<String> m_aValueProvider;

    public ConfigurationSourceFunction(@Nonnull UnaryOperator<String> unaryOperator) {
        this(SOURCE_TYPE.getDefaultPriority(), unaryOperator);
    }

    public ConfigurationSourceFunction(int n, @Nonnull UnaryOperator<String> unaryOperator) {
        super(SOURCE_TYPE, n);
        ValueEnforcer.notNull(unaryOperator, (String)"ValueProvider");
        this.m_aValueProvider = unaryOperator;
    }

    @Nonnull
    public final UnaryOperator<String> getValueProvider() {
        return this.m_aValueProvider;
    }

    @Override
    public boolean isInitializedAndUsable() {
        return true;
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        String string2 = (String)this.m_aValueProvider.apply(string);
        if (string2 == null) {
            return null;
        }
        if (ConfigurationSourceFunction.hasTrailingWhitespace(string2)) {
            LOGGER.warn("The value of the configuration key '" + string + "' has a trailing whitespace. This may lead to unintended side effects.");
        }
        return new ConfiguredValue(this, string2);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ValueProvider", this.m_aValueProvider).getToString();
    }
}

