/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.appl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.value.ConfiguredValue;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConfigurationSourceFunction
extends AbstractConfigurationSource {
    public static final EConfigSourceType SOURCE_TYPE = EConfigSourceType.APPLICATION;
    private final Function<String, String> m_aValueProvider;

    public ConfigurationSourceFunction(@Nonnull Function<String, String> function) {
        this(SOURCE_TYPE.getDefaultPriority(), function);
    }

    public ConfigurationSourceFunction(int n, @Nonnull Function<String, String> function) {
        super(SOURCE_TYPE, n);
        ValueEnforcer.notNull(function, (String)"ValueProvider");
        this.m_aValueProvider = function;
    }

    @Nonnull
    public final Function<String, String> getValueProvider() {
        return this.m_aValueProvider;
    }

    @Override
    public boolean isInitializedAndUsable() {
        return true;
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        String string2 = this.m_aValueProvider.apply(string);
        return string2 == null ? null : new ConfiguredValue(this, string2);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ValueProvider", this.m_aValueProvider).getToString();
    }
}

