/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config;

import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.resourceprovider.ClassPathResourceProvider;
import com.helger.commons.io.resourceprovider.FileSystemResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.config.Config;
import com.helger.config.IConfig;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.envvar.ConfigurationSourceEnvVar;
import com.helger.config.source.res.ConfigurationSourceJson;
import com.helger.config.source.res.ConfigurationSourceProperties;
import com.helger.config.source.res.EConfigSourceResourceType;
import com.helger.config.source.sysprop.ConfigurationSourceSystemProperty;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ConfigFactory {
    public static final int PRIVATE_APPLICATION_JSON_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 5;
    public static final int PRIVATE_APPLICATION_PROPERTIES_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 10;
    public static final int APPLICATION_JSON_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 15;
    public static final int APPLICATION_PROPERTIES_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 20;
    public static final int REFERENCE_PROPERTIES_PRIORITY = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFactory.class);
    private static final EConfigSourceResourceType FALLBACK_SOURCE_TYPE = EConfigSourceResourceType.PROPERTIES;
    private static final IConfig SYSTEM_ONLY = Config.create(ConfigFactory.createValueProviderSystemOnly());
    private static final IConfig DEFAULT_INSTANCE = Config.create(ConfigFactory.createDefaultValueProvider());

    @Nonnull
    public static MultiConfigurationValueProvider createValueProviderSystemOnly() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        return multiConfigurationValueProvider;
    }

    @Nonnull
    public static ReadableResourceProviderChain createDefaultResourceProviderChain() {
        return new ReadableResourceProviderChain(new IReadableResourceProvider[]{new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider()});
    }

    @Nonnull
    public static MultiConfigurationValueProvider createDefaultValueProvider() {
        int n;
        Object object;
        EConfigSourceResourceType eConfigSourceResourceType;
        MultiConfigurationValueProvider multiConfigurationValueProvider = new MultiConfigurationValueProvider();
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceSystemProperty());
        multiConfigurationValueProvider.addConfigurationSource(new ConfigurationSourceEnvVar());
        int n2 = EConfigSourceType.RESOURCE.getDefaultPriority();
        ClassLoader classLoader = ClassLoaderHelper.getDefaultClassLoader();
        String string = SYSTEM_ONLY.getAsString("config.resource");
        if (StringHelper.hasText((String)string)) {
            eConfigSourceResourceType = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = new ClassPathResource(string);
            if (object.exists()) {
                n = SYSTEM_ONLY.getAsInt("config.resource.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(eConfigSourceResourceType.createConfigurationSource((IReadableResource)object), n);
            }
        }
        if (StringHelper.hasText((String)(string = SYSTEM_ONLY.getAsString("config.resources")))) {
            int n3 = SYSTEM_ONLY.getAsInt("config.resources.priority", n2);
            object = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForClassPath(classLoader, string, arg_0 -> ConfigFactory.lambda$createDefaultValueProvider$0((EConfigSourceResourceType)((Object)object), arg_0)), n3);
        }
        if (StringHelper.hasText((String)(string = SYSTEM_ONLY.getAsString("config.file")))) {
            eConfigSourceResourceType = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = new FileSystemResource(string);
            if (object.exists()) {
                n = SYSTEM_ONLY.getAsInt("config.file.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(eConfigSourceResourceType.createConfigurationSource((IReadableResource)object), n);
            }
        }
        if (StringHelper.hasText((String)(string = SYSTEM_ONLY.getAsString("config.url")))) {
            URLResource uRLResource;
            eConfigSourceResourceType = EConfigSourceResourceType.getFromExtensionOrDefault(FilenameHelper.getExtension((String)string), FALLBACK_SOURCE_TYPE);
            object = URLHelper.getAsURL((String)string);
            if (object != null && (uRLResource = new URLResource((URL)object)).exists()) {
                int n4 = SYSTEM_ONLY.getAsInt("config.url.priority", n2);
                multiConfigurationValueProvider.addConfigurationSource(eConfigSourceResourceType.createConfigurationSource((IReadableResource)uRLResource), n4);
            }
        }
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, "private-application.json", uRL -> new ConfigurationSourceJson((IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), PRIVATE_APPLICATION_JSON_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, "private-application.properties", uRL -> new ConfigurationSourceProperties((IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), PRIVATE_APPLICATION_PROPERTIES_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, "application.json", uRL -> new ConfigurationSourceJson((IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), APPLICATION_JSON_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, "application.properties", uRL -> new ConfigurationSourceProperties((IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), APPLICATION_PROPERTIES_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource(MultiConfigurationValueProvider.createForAllOccurrances(classLoader, "reference.properties", uRL -> new ConfigurationSourceProperties((IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), true), 1);
        return multiConfigurationValueProvider;
    }

    private ConfigFactory() {
    }

    @Nonnull
    public static IConfig getSystemConfig() {
        return SYSTEM_ONLY;
    }

    @Nonnull
    public static IConfig getDefaultConfig() {
        return DEFAULT_INSTANCE;
    }

    private static /* synthetic */ IConfigurationSource lambda$createDefaultValueProvider$0(EConfigSourceResourceType eConfigSourceResourceType, URL uRL) {
        return eConfigSourceResourceType.createConfigurationSource((IReadableResource)new URLResource(uRL));
    }

    static {
        int n = DEFAULT_INSTANCE.getResourceBasedConfigurationValueProviderCount();
        if (n == 0) {
            LOGGER.info("The default Config instance is based soley on system properties and environment variables. No configuration resources were found.");
        }
    }
}

