/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.json.source;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.ESuccess;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.config.source.IConfigurationSource;
import com.helger.config.source.resource.AbstractConfigurationSourceResource;
import com.helger.config.value.ConfiguredValue;
import com.helger.io.resource.IReadableResource;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonReader;
import java.nio.charset.Charset;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigurationSourceJson
extends AbstractConfigurationSourceResource {
    public static final String FILE_EXT = "json";
    public static final char LEVEL_SEPARATOR = '.';
    public static final String ARRAY_SUFFIX_COUNT = "$count";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceJson.class);
    private final Charset m_aCharset;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private ICommonsOrderedMap<String, String> m_aProps;

    private static void _recursiveFlattenJson(@NonNull String string, @NonNull IJson iJson, @NonNull Map<String, String> map) {
        if (iJson.isValue()) {
            map.put(string, iJson.getAsValue().getAsString());
        } else if (iJson.isObject()) {
            for (Map.Entry entry : iJson.getAsObject()) {
                ConfigurationSourceJson._recursiveFlattenJson(string + "." + (String)entry.getKey(), (IJson)entry.getValue(), map);
            }
        } else {
            IJsonArray iJsonArray = iJson.getAsArray();
            map.put(string + ".$count", Integer.toString(iJsonArray.size()));
            int n = 0;
            for (IJson iJson2 : iJsonArray) {
                ConfigurationSourceJson._recursiveFlattenJson(string + "." + n, iJson2, map);
                ++n;
            }
        }
    }

    private static @Nullable ICommonsOrderedMap<String, String> _load(@NonNull IReadableResource iReadableResource, @NonNull Charset charset) {
        IJsonObject iJsonObject;
        JsonReader.JsonBuilder jsonBuilder = JsonReader.builder().source((IHasInputStream)iReadableResource, charset).requireStringQuotes(false).allowSpecialCharsInStrings(true).alwaysUseBigNumber(true).trackPosition(true).customExceptionCallback(jsonParseException -> LOGGER.error("Failed to parse '" + iReadableResource.getPath() + "' to JSON: " + jsonParseException.getMessage()));
        IJsonObject iJsonObject2 = iJsonObject = jsonBuilder.hasSource() ? jsonBuilder.readAsObject() : null;
        if (iJsonObject == null) {
            return null;
        }
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : iJsonObject) {
            ConfigurationSourceJson._recursiveFlattenJson((String)entry.getKey(), (IJson)entry.getValue(), (Map<String, String>)commonsLinkedHashMap);
        }
        return commonsLinkedHashMap;
    }

    public ConfigurationSourceJson(@NonNull IReadableResource iReadableResource) {
        this(CONFIG_SOURCE_TYPE.getDefaultPriority(), iReadableResource, null);
    }

    public ConfigurationSourceJson(@NonNull IReadableResource iReadableResource, @Nullable Charset charset) {
        this(CONFIG_SOURCE_TYPE.getDefaultPriority(), iReadableResource, charset);
    }

    public ConfigurationSourceJson(int n, @NonNull IReadableResource iReadableResource) {
        this(n, iReadableResource, null);
    }

    public ConfigurationSourceJson(int n, @NonNull IReadableResource iReadableResource, @Nullable Charset charset) {
        super(n, iReadableResource);
        this.m_aCharset = charset != null ? charset : JsonReader.DEFAULT_CHARSET;
        this.m_aProps = ConfigurationSourceJson._load(iReadableResource, this.m_aCharset);
        if (this.m_aProps != null) {
            for (Map.Entry entry : this.m_aProps.entrySet()) {
                if (!ConfigurationSourceJson.hasTrailingWhitespace((String)((String)entry.getValue()))) continue;
                LOGGER.warn("The value of the JSON configuration property '" + (String)entry.getKey() + "' has a trailing whitespace. This may lead to unintended side effects.");
            }
        }
    }

    public final @NonNull Charset getCharset() {
        return this.m_aCharset;
    }

    public boolean isInitializedAndUsable() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aProps != null);
    }

    public @NonNull ESuccess reload() {
        ICommonsOrderedMap<String, String> iCommonsOrderedMap = ConfigurationSourceJson._load(this.getResource(), this.m_aCharset);
        this.m_aRWLock.writeLocked(() -> {
            this.m_aProps = iCommonsOrderedMap;
        });
        return ESuccess.valueOf((iCommonsOrderedMap != null ? 1 : 0) != 0);
    }

    public @Nullable ConfiguredValue getConfigurationValue(@NonNull @Nonempty String string) {
        String string2 = (String)this.m_aRWLock.readLockedGet(() -> this.m_aProps == null ? null : (String)this.m_aProps.get((Object)string));
        return string2 == null ? null : new ConfiguredValue((IConfigurationSource)this, string2);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, String> getAllConfigItems() {
        return (ICommonsOrderedMap)this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashMap(this.m_aProps));
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Properties", (Object)ConfigurationSourceJson.mapToStringIgnoreSecrets(this.m_aProps)).getToString();
    }
}

