/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.json;

import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.config.ConfigFactory;
import com.helger.config.json.source.ConfigurationSourceJson;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;

public final class ConfigFactoryJson {
    public static final String PRIVATE_APPLICATION_JSON_NAME = "private-application.json";
    public static final int PRIVATE_APPLICATION_JSON_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 5;
    public static final String APPLICATION_JSON_NAME = "application.json";
    public static final int APPLICATION_JSON_PRIORITY = EConfigSourceType.RESOURCE.getDefaultPriority() - 15;

    private ConfigFactoryJson() {
    }

    public static void addDefaultJsonConfiguration(@Nonnull MultiConfigurationValueProvider multiConfigurationValueProvider) {
        ClassLoader classLoader = ClassLoaderHelper.getDefaultClassLoader();
        multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)MultiConfigurationValueProvider.createForAllOccurrances((ClassLoader)classLoader, (String)PRIVATE_APPLICATION_JSON_NAME, uRL -> new ConfigurationSourceJson(PRIVATE_APPLICATION_JSON_PRIORITY, (IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), (boolean)true), PRIVATE_APPLICATION_JSON_PRIORITY);
        multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)MultiConfigurationValueProvider.createForAllOccurrances((ClassLoader)classLoader, (String)APPLICATION_JSON_NAME, uRL -> new ConfigurationSourceJson(APPLICATION_JSON_PRIORITY, (IReadableResource)new URLResource(uRL), StandardCharsets.UTF_8), (boolean)true), APPLICATION_JSON_PRIORITY);
    }

    @Nonnull
    public static MultiConfigurationValueProvider createDefaultValueProvider() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        ConfigFactoryJson.addDefaultJsonConfiguration(multiConfigurationValueProvider);
        return multiConfigurationValueProvider;
    }
}

