/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.vendor;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.email.EmailAddressHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public final class VendorInfo {
    public static final String DEFAULT_VENDOR_LOCATION = "Vienna, Austria, Europe, World, Milky Way, Universe";
    public static final String DEFAULT_VENDOR_NAME = "Philip Helger";
    public static final String DEFAULT_VENDOR_URL_WITHOUT_PROTOCOL = "www.helger.com";
    public static final String DEFAULT_VENDOR_URL = "http://www.helger.com";
    public static final String VENDOR_PERSON_PHILIP = "Philip Helger";
    public static final String DEFAULT_VENDOR_EMAIL_SUFFIX = "@helger.com";
    public static final String DEFAULT_VENDOR_EMAIL = "office@helger.com";
    public static final int DEFAULT_INCEPTION_YEAR = 2014;
    private static final VendorInfo INSTANCE = new VendorInfo();
    private static String s_sVendorLocation = "Vienna, Austria, Europe, World, Milky Way, Universe";
    private static int s_nInceptionYear = 2014;
    private static String s_sVendorName = "Philip Helger";
    private static String s_sVendorURL = "http://www.helger.com";
    private static String s_sVendorEmailSuffix = "@helger.com";
    private static String s_sVendorEmail = "office@helger.com";

    private VendorInfo() {
    }

    public static @NonNull String getVendorLocation() {
        return s_sVendorLocation;
    }

    public static void setVendorLocation(@NonNull @Nonempty String string) {
        s_sVendorLocation = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"VendorLocation");
    }

    @Nonnegative
    public static int getInceptionYear() {
        return s_nInceptionYear;
    }

    public static void setInceptionYear(@Nonnegative int n) {
        s_nInceptionYear = ValueEnforcer.isGE0((int)n, (String)"InceptionYear");
    }

    public static @NonNull String getVendorName() {
        return s_sVendorName;
    }

    public static void setVendorName(@NonNull @Nonempty String string) {
        s_sVendorName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"VendorName");
    }

    public static @NonNull String getVendorURL() {
        return s_sVendorURL;
    }

    public static void setVendorURL(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"VendorURL");
        s_sVendorURL = string;
    }

    public static @NonNull String getVendorEmail() {
        return s_sVendorEmail;
    }

    public static @NonNull String getVendorEmailSuffix() {
        return s_sVendorEmailSuffix;
    }

    public static void setVendorEmail(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"VendorEmail");
        ValueEnforcer.isTrue((boolean)EmailAddressHelper.isValid((String)string), () -> "Illegal vendor email: " + string);
        s_sVendorEmail = string;
        s_sVendorEmailSuffix = StringHelper.getFromFirstIncl((String)string, (char)'@');
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<String> getFileHeaderLines() {
        int n = PDTFactory.getCurrentYear();
        return new CommonsArrayList((Object[])new String[]{"THIS FILE IS GENERATED - DO NOT EDIT", "", "Copyright", "", "Copyright (c) " + VendorInfo.getVendorName() + " " + VendorInfo.getInceptionYear() + " - " + n, VendorInfo.getVendorURL(), "", "All Rights Reserved", "Use, duplication or disclosure restricted by " + VendorInfo.getVendorName(), "", VendorInfo.getVendorLocation() + ", " + VendorInfo.getInceptionYear() + " - " + n});
    }
}

