/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.math.BigInteger;
import org.jspecify.annotations.NonNull;

@Immutable
public final class FactorialHelper {
    private static final long[] PREDEFINED_FACTORIALS_LONG = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    public static final int PREDEFINED_MIN_INDEX = 0;
    public static final int PREDEFINED_MAX_INDEX = PREDEFINED_FACTORIALS_LONG.length - 1;
    private static final FactorialHelper INSTANCE = new FactorialHelper();

    private FactorialHelper() {
    }

    @Nonnegative
    public static long getSmallFactorial(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"n", (int)0, (int)PREDEFINED_MAX_INDEX);
        return PREDEFINED_FACTORIALS_LONG[n];
    }

    public static @NonNull BigInteger getAnyFactorialLinear(@Nonnegative int n) {
        return new FactorialSplit().getFactorial(n);
    }

    private static final class FactorialSplit {
        private long m_nCurrentN;

        FactorialSplit() {
        }

        private @NonNull BigInteger _getProduct(int n) {
            int n2 = n / 2;
            if (n2 == 0) {
                this.m_nCurrentN += 2L;
                return BigInteger.valueOf(this.m_nCurrentN);
            }
            if (n == 2) {
                this.m_nCurrentN += 2L;
                long l = this.m_nCurrentN;
                this.m_nCurrentN += 2L;
                long l2 = this.m_nCurrentN;
                return BigInteger.valueOf(l * l2);
            }
            return this._getProduct(n - n2).multiply(this._getProduct(n2));
        }

        public @NonNull BigInteger getFactorial(@Nonnegative int n) {
            ValueEnforcer.isGE0((int)n, (String)"n");
            if (n < 2) {
                return BigInteger.ONE;
            }
            BigInteger bigInteger = BigInteger.ONE;
            BigInteger bigInteger2 = BigInteger.ONE;
            this.m_nCurrentN = 1L;
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            int n5 = 31 - Integer.numberOfLeadingZeros(n);
            while (n2 != n) {
                n3 += n2;
                n2 = n >> n5--;
                int n6 = n4;
                n4 = n2 - 1 | 1;
                if ((n6 = (n4 - n6) / 2) <= 0) continue;
                bigInteger = bigInteger.multiply(this._getProduct(n6));
                bigInteger2 = bigInteger2.multiply(bigInteger);
            }
            return bigInteger2.shiftLeft(n3);
        }
    }
}

