/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.commons.math.CombinationGenerator;
import java.util.Iterator;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;

@Immutable
public final class CombinationGeneratorFlexible<DATATYPE> {
    private final boolean m_bAllowEmpty;
    private final int m_nSlotCount;

    public CombinationGeneratorFlexible(@Nonnegative int n, boolean bl) {
        ValueEnforcer.isGE0((int)n, (String)"SlotCount");
        this.m_nSlotCount = n;
        this.m_bAllowEmpty = bl;
    }

    public void iterateAllCombinations(@NonNull ICommonsList<DATATYPE> iCommonsList, @NonNull Consumer<? super ICommonsList<DATATYPE>> consumer) {
        int n;
        ValueEnforcer.notNull(iCommonsList, (String)"Elements");
        ValueEnforcer.notNull(consumer, (String)"Callback");
        int n2 = n = this.m_bAllowEmpty ? 0 : 1;
        while (n <= this.m_nSlotCount) {
            if (iCommonsList.isEmpty()) {
                consumer.accept((ICommonsList<DATATYPE>)new CommonsArrayList());
            } else {
                Iterator iterator = new CombinationGenerator<DATATYPE>(iCommonsList, n).iterator();
                while (iterator.hasNext()) {
                    ICommonsList iCommonsList2 = (ICommonsList)iterator.next();
                    consumer.accept(iCommonsList2);
                }
            }
            ++n;
        }
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<ICommonsList<DATATYPE>> getCombinations(@NonNull ICommonsList<DATATYPE> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Elements");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        this.iterateAllCombinations(iCommonsList, arg_0 -> ((ICommonsSet)commonsHashSet).add(arg_0));
        return commonsHashSet;
    }

    public static <DATATYPE> void iterateAllCombinations(@NonNull ICommonsList<DATATYPE> iCommonsList, boolean bl, @NonNull Consumer<? super ICommonsList<DATATYPE>> consumer) {
        new CombinationGeneratorFlexible<DATATYPE>(iCommonsList.size(), bl).iterateAllCombinations(iCommonsList, consumer);
    }

    @ReturnsMutableCopy
    public static <DATATYPE> @NonNull ICommonsSet<ICommonsList<DATATYPE>> getCombinations(@NonNull ICommonsList<DATATYPE> iCommonsList, boolean bl) {
        return new CombinationGeneratorFlexible<DATATYPE>(iCommonsList.size(), bl).getCombinations(iCommonsList);
    }
}

