/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.management.ThreadInfo;

@Immutable
public class ThreadDeadlockInfo {
    private final ThreadInfo m_aThreadInfo;
    private final Thread m_aThread;
    private final StackTraceElement[] m_aStackTrace;

    public ThreadDeadlockInfo(@Nonnull ThreadInfo threadInfo, @Nonnull Thread thread, @Nullable StackTraceElement[] stackTraceElementArray) {
        this.m_aThreadInfo = (ThreadInfo)ValueEnforcer.notNull((Object)threadInfo, (String)"ThreadInfo");
        this.m_aThread = (Thread)ValueEnforcer.notNull((Object)thread, (String)"Thread");
        this.m_aStackTrace = (StackTraceElement[])ArrayHelper.getCopy((Object[])stackTraceElementArray);
    }

    @Nonnull
    public ThreadInfo getThreadInfo() {
        return this.m_aThreadInfo;
    }

    @Nonnull
    public Thread getThread() {
        return this.m_aThread;
    }

    public boolean hasStackTrace() {
        return this.m_aStackTrace != null;
    }

    @Nullable
    @ReturnsMutableCopy
    public StackTraceElement[] getAllStackTraceElements() {
        return (StackTraceElement[])ArrayHelper.getCopy((Object[])this.m_aStackTrace);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("threadInfo", (Object)this.m_aThreadInfo).append("thread", (Object)this.m_aThread).appendIfNotNull("stackTrace", (Object)this.m_aStackTrace).getToString();
    }
}

