/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.homoglyphs;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.map.IntObjectMap;
import com.helger.collection.set.IntSet;
import com.helger.commons.homoglyphs.HomoglyphSearchResult;
import jakarta.annotation.Nonnull;
import java.nio.IntBuffer;

@Immutable
public class Homoglyph {
    private final IntObjectMap<IntSet> m_aLookup = new IntObjectMap();

    public Homoglyph(@Nonnull ICommonsList<IntSet> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Homoglyphs");
        for (IntSet intSet : iCommonsList) {
            intSet.forEach(n -> this.m_aLookup.put(n, (Object)intSet));
        }
    }

    private boolean _checkForHomoglyphs(int n, int n2) {
        if (n == n2) {
            return true;
        }
        IntSet intSet = (IntSet)this.m_aLookup.get(n);
        return intSet != null && intSet.contains(n2);
    }

    private boolean _hasWordAtIndex(CodePoints codePoints, CodePoints codePoints2, int n) {
        for (int i = 0; i < codePoints2.getLength(); ++i) {
            int n2 = codePoints2.getValue(i);
            int n3 = Character.toLowerCase(n2);
            int n4 = Character.toUpperCase(n2);
            int n5 = codePoints.getValue(n + i);
            if (this._checkForHomoglyphs(n3, n5) || this._checkForHomoglyphs(n4, n5)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private ICommonsList<HomoglyphSearchResult> _checkForWord(CodePoints codePoints, CodePoints codePoints2) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n = codePoints.getLength() - codePoints2.getLength();
        for (int i = 0; i <= n; ++i) {
            if (!this._hasWordAtIndex(codePoints, codePoints2, i)) continue;
            commonsArrayList.add((Object)new HomoglyphSearchResult(i, codePoints.subStringAt(i, codePoints2.getLength()), codePoints2.getText()));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<HomoglyphSearchResult> search(String string, Iterable<String> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CodePoints codePoints = new CodePoints(string);
        for (String string2 : iterable) {
            commonsArrayList.addAll(this._checkForWord(codePoints, new CodePoints(string2)));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<HomoglyphSearchResult> search(String string, String ... stringArray) {
        return this.search(string, (Iterable<String>)new CommonsArrayList((Object[])stringArray));
    }

    private static final class CodePoints {
        private final String m_sText;
        private final int[] m_aCodepoints;

        public CodePoints(@Nonnull String string) {
            this.m_sText = string;
            IntBuffer intBuffer = IntBuffer.allocate(string.length());
            StringHelper.iterateCodePoints((String)string, intBuffer::put);
            intBuffer.flip();
            this.m_aCodepoints = new int[intBuffer.limit()];
            intBuffer.get(this.m_aCodepoints);
        }

        public int getValue(int n) {
            return this.m_aCodepoints[n];
        }

        @Nonnegative
        public int getLength() {
            return this.m_aCodepoints.length;
        }

        @Nonnull
        public String getText() {
            return this.m_sText;
        }

        @Nonnull
        public String subStringAt(@Nonnegative int n, @Nonnegative int n2) {
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = 0; i < n2; ++i) {
                stringBuilder.appendCodePoint(this.m_aCodepoints[n + i]);
            }
            return stringBuilder.toString();
        }
    }
}

