/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.state.EChange;
import com.helger.base.state.IStoppable;
import com.helger.commons.deadlock.ThreadDeadlockDetector;
import jakarta.annotation.Nonnull;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDeadlockDetectionTimer
extends ThreadDeadlockDetector
implements IStoppable {
    public static final long DEFAULT_DEADLOCK_CHECK_PERIOD = 10000L;
    public static final long INITIAL_DELAY_MS = 10L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDeadlockDetectionTimer.class);
    private final TimerTask m_aTimerTask;
    private final Timer m_aThreadCheck = new Timer("ThreadDeadlockDetector", true);

    public ThreadDeadlockDetectionTimer() {
        this(10000L);
    }

    public ThreadDeadlockDetectionTimer(@Nonnegative long l) {
        this.m_aTimerTask = new DetectorTimerTask();
        this.m_aThreadCheck.schedule(this.m_aTimerTask, 10L, l);
        LOGGER.info("Deadlock detector started!");
    }

    @Nonnull
    public EChange stop() {
        if (!this.m_aTimerTask.cancel()) {
            return EChange.UNCHANGED;
        }
        LOGGER.info("Deadlock detector stopped!");
        return EChange.CHANGED;
    }

    private final class DetectorTimerTask
    extends TimerTask {
        private DetectorTimerTask() {
        }

        @Override
        public void run() {
            ThreadDeadlockDetectionTimer.this.findDeadlockedThreads();
        }
    }
}

