/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.datetime.EDTFormatterMode;
import com.helger.commons.datetime.OffsetDate;
import com.helger.commons.datetime.PDTFormatter;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.datetime.XMLOffsetTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTToString {
    private static final PDTToString INSTANCE = new PDTToString();

    private PDTToString() {
    }

    @Nullable
    public static String getAsString(@Nullable LocalDate localDate, @Nonnull Locale locale) {
        return localDate == null ? null : PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDate);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetDate offsetDate, @Nonnull Locale locale) {
        return offsetDate == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDate);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetDate xMLOffsetDate, @Nonnull Locale locale) {
        return xMLOffsetDate == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDate);
    }

    @Nullable
    public static String getAsString(@Nullable LocalTime localTime, @Nonnull Locale locale) {
        return localTime == null ? null : PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localTime);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetTime offsetTime, @Nonnull Locale locale) {
        return offsetTime == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetTime);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetTime xMLOffsetTime, @Nonnull Locale locale) {
        return xMLOffsetTime == null ? null : PDTFormatter.getFormatterOffsetTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetTime);
    }

    @Nullable
    public static String getAsString(@Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        return localDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(localDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        return zonedDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(zonedDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable OffsetDateTime offsetDateTime, @Nonnull Locale locale) {
        return offsetDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(offsetDateTime);
    }

    @Nullable
    public static String getAsString(@Nullable XMLOffsetDateTime xMLOffsetDateTime, @Nonnull Locale locale) {
        return xMLOffsetDateTime == null ? null : PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PRINT).format(xMLOffsetDateTime);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor) {
        return PDTToString.getAsString(string, temporalAccessor, null);
    }

    @Nullable
    public static String getAsString(@Nonnull String string, @Nullable TemporalAccessor temporalAccessor, @Nullable Locale locale) {
        return temporalAccessor == null ? null : PDTFormatter.getForPattern(string, locale).format(temporalAccessor);
    }
}

