/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;

@Immutable
final class MapHelper {
    private static final int INT_PHI = -1640531527;

    private MapHelper() {
    }

    public static long nextPowerOfTwo(long l) {
        if (l == 0L) {
            return 1L;
        }
        long l2 = l - 1L;
        l2 |= l2 >> 1;
        l2 |= l2 >> 2;
        l2 |= l2 >> 4;
        l2 |= l2 >> 8;
        l2 |= l2 >> 16;
        return (l2 | l2 >> 32) + 1L;
    }

    @Nonnegative
    public static int arraySize(int n, float f) {
        long l = Math.max(2L, MapHelper.nextPowerOfTwo((long)Math.ceil((float)n / f)));
        if (l > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + n + " expected elements with load factor " + f + ")");
        }
        return (int)l;
    }

    public static int phiMix(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >> 16;
    }
}

