/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsOrderedMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CommonsLinkedHashMap<KEYTYPE, VALUETYPE>
extends LinkedHashMap<KEYTYPE, VALUETYPE>
implements ICommonsOrderedMap<KEYTYPE, VALUETYPE> {
    public CommonsLinkedHashMap() {
    }

    public CommonsLinkedHashMap(@Nonnegative int n) {
        super(n);
    }

    public CommonsLinkedHashMap(@Nonnegative int n, float f) {
        super(n, f);
    }

    public CommonsLinkedHashMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(CollectionHelper.getSize(map));
        if (map != null) {
            this.putAll(map);
        }
    }

    public CommonsLinkedHashMap(@Nonnegative int n, float f, boolean bl) {
        super(n, f, bl);
    }

    public <COLLTYPE> CommonsLinkedHashMap(@Nullable COLLTYPE[] COLLTYPEArray, @NonNull Function<? super COLLTYPE, ? extends KEYTYPE> function, @NonNull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(ArrayHelper.getSize((Object[])COLLTYPEArray));
        this.putAllMapped(COLLTYPEArray, function, function2);
    }

    public <COLLTYPE> CommonsLinkedHashMap(@Nullable Collection<? extends COLLTYPE> collection, @NonNull Function<? super COLLTYPE, ? extends KEYTYPE> function, @NonNull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(collection));
        this.putAllMapped(collection, function, function2);
    }

    public <SRCKEYTYPE, SRCVALUETYPE> CommonsLinkedHashMap(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCKEYTYPE, ? extends KEYTYPE> function, @NonNull Function<? super SRCVALUETYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(map));
        this.putAllMapped(map, function, function2);
    }

    @Override
    @ReturnsMutableCopy
    public <K, V> @NonNull CommonsLinkedHashMap<K, V> createInstance() {
        return new CommonsLinkedHashMap<KEYTYPE, VALUETYPE>();
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull CommonsLinkedHashMap<KEYTYPE, VALUETYPE> getClone() {
        return new CommonsLinkedHashMap<KEYTYPE, VALUETYPE>(this);
    }
}

