/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CollectionCommonsHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.helper.CollectionHelperExt;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Immutable
public class CollectionSort {
    private CollectionSort() {
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>, LISTTYPE extends List<ELEMENTTYPE>> LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE) {
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(null);
        }
        return LISTTYPE;
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, LISTTYPE extends List<ELEMENTTYPE>> LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(comparator);
        }
        return LISTTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return CollectionCommonsHelper.getSortedByKey(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super KEYTYPE> comparator) {
        return CollectionCommonsHelper.getSortedByKey(map, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return CollectionCommonsHelper.getSortedByValue(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super VALUETYPE> comparator) {
        return CollectionCommonsHelper.getSortedByValue(map, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iCommonsIterableIterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iCommonsIterableIterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterable));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterable), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(collection), comparator);
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> CommonsArrayList<ELEMENTTYPE> getSorted(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(ELEMENTTYPEArray), comparator);
    }
}

