/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.list;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.EmptyIterator;
import com.helger.collection.base.EmptyListIterator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.iterator.SingleElementIterator;
import com.helger.collection.iterator.SingleElementListIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

@NotThreadSafe
public class SingleElementList<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    private boolean m_bHasElement;
    private ELEMENTTYPE m_aElement;

    public SingleElementList() {
        this.m_bHasElement = false;
        this.m_aElement = null;
    }

    public SingleElementList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T> SingleElementList<T> createInstance() {
        return new SingleElementList<ELEMENTTYPE>();
    }

    @Nonnull
    @ReturnsMutableCopy
    public SingleElementList<ELEMENTTYPE> getClone() {
        return this.m_bHasElement ? new SingleElementList<ELEMENTTYPE>(this.m_aElement) : new SingleElementList<ELEMENTTYPE>();
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
        return true;
    }

    @Override
    public void add(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        ValueEnforcer.isTrue((n == 0 ? 1 : 0) != 0, () -> "Only 1 elements is allowed: " + n);
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        ValueEnforcer.notNull(collection, (String)"Elements");
        ValueEnforcer.isTrue((collection.size() <= 1 ? 1 : 0) != 0, (String)"Cannot add lists with more than one element!");
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        Iterator<ELEMENTTYPE> iterator = collection.iterator();
        return iterator.hasNext() && this.add(iterator.next());
    }

    @Override
    public boolean addAll(@Nonnegative int n, @Nonnull Collection<? extends ELEMENTTYPE> collection) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Only index 0 is valid!");
        }
        return this.addAll(collection);
    }

    @Override
    public void clear() {
        this.m_aElement = null;
        this.m_bHasElement = false;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        ELEMENTTYPE ELEMENTTYPE = this.m_aElement;
        return this.m_bHasElement && EqualsHelper.equals(ELEMENTTYPE, (Object)object);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_aElement;
    }

    @Override
    public int indexOf(Object object) {
        return this.contains(object) ? 0 : -1;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_bHasElement ? new SingleElementIterator<ELEMENTTYPE>(this.m_aElement) : new EmptyIterator();
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return this.contains(object) ? 0 : -1;
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_bHasElement ? new SingleElementListIterator<ELEMENTTYPE>(this.m_aElement) : new EmptyListIterator();
    }

    @Override
    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.listIterator();
    }

    @Override
    @Nullable
    public ELEMENTTYPE remove(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aElement;
        this.m_aElement = null;
        this.m_bHasElement = false;
        return ELEMENTTYPE;
    }

    @Override
    public boolean remove(@Nullable Object object) {
        if (!this.contains(object)) {
            return false;
        }
        this.m_aElement = null;
        this.m_bHasElement = false;
        return true;
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> collection) {
        boolean bl = true;
        if (collection != null) {
            for (Object obj : collection) {
                if (this.remove(obj)) continue;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        ValueEnforcer.notNull(collection, (String)"Elements");
        if (this.m_bHasElement) {
            if (collection.contains(this.m_aElement)) {
                return true;
            }
            this.clear();
        }
        return false;
    }

    @Override
    @Nullable
    public ELEMENTTYPE set(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n != 0) {
            throw new IllegalArgumentException("The passed index can onyl be 0!");
        }
        ELEMENTTYPE ELEMENTTYPE2 = this.m_aElement;
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
        return ELEMENTTYPE2;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    @CodingStyleguideUnaware
    public ICommonsList<ELEMENTTYPE> subList(@Nonnegative int n, @Nonnegative int n2) {
        if (n < 0 || n > (this.m_bHasElement ? 1 : 0)) {
            throw new IndexOutOfBoundsException("Invalid from index " + n);
        }
        if (n2 < 0 || n2 > (this.m_bHasElement ? 1 : 0)) {
            throw new IndexOutOfBoundsException("Invalid to index " + n2);
        }
        if (!this.m_bHasElement || n == n2) {
            return new CommonsArrayList<boolean>(false);
        }
        return this;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.m_bHasElement) {
            Object[] objectArray = new Object[]{this.m_aElement};
            return objectArray;
        }
        return CGlobal.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nonnull
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(@Nonnull ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        ValueEnforcer.notNull(ARRAYELEMENTTYPEArray, (String)"Dest");
        if (!this.m_bHasElement) {
            return ARRAYELEMENTTYPEArray;
        }
        if (this.m_aElement != null && !ARRAYELEMENTTYPEArray.getClass().getComponentType().isAssignableFrom(this.m_aElement.getClass())) {
            throw new ArrayStoreException("The array class " + String.valueOf(ARRAYELEMENTTYPEArray.getClass()) + " cannot store the item of class " + String.valueOf(this.m_aElement.getClass()));
        }
        ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray2 = ARRAYELEMENTTYPEArray.length < 1 ? ArrayHelper.createArraySameType((Object[])ARRAYELEMENTTYPEArray, (int)1) : ARRAYELEMENTTYPEArray;
        ARRAYELEMENTTYPEArray2[0] = GenericReflection.uncheckedCast(this.m_aElement);
        if (ARRAYELEMENTTYPEArray2.length > 1) {
            ARRAYELEMENTTYPEArray2[1] = null;
        }
        return ARRAYELEMENTTYPEArray2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementList singleElementList = (SingleElementList)object;
        ELEMENTTYPE ELEMENTTYPE = this.m_aElement;
        return this.m_bHasElement == singleElementList.m_bHasElement && EqualsHelper.equals(ELEMENTTYPE, singleElementList.m_aElement);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasElement).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasElement", this.m_bHasElement).append("element", this.m_aElement).getToString();
    }
}

