/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@NotThreadSafe
public class ReverseListIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    @CodingStyleguideUnaware
    private final List<? extends ELEMENTTYPE> m_aList;
    private int m_nIndex;

    public ReverseListIterator(@Nonnull List<? extends ELEMENTTYPE> list) {
        this.m_aList = (List)ValueEnforcer.notNull(list, (String)"List");
        this.m_nIndex = list.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex >= 0;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_nIndex < 0) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aList.get(this.m_nIndex);
        --this.m_nIndex;
        return ELEMENTTYPE;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).append("index", this.m_nIndex).getToString();
    }
}

