/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionCommonsHelper {
    private CollectionCommonsHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    private static <KEYTYPE, VALUETYPE> CommonsLinkedHashMap<KEYTYPE, VALUETYPE> _newOrderedMap(@Nullable List<? extends Map.Entry<KEYTYPE, VALUETYPE>> list) {
        CommonsLinkedHashMap<KEYTYPE, VALUETYPE> commonsLinkedHashMap = new CommonsLinkedHashMap<KEYTYPE, VALUETYPE>(list.size());
        commonsLinkedHashMap.putAll(list);
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return new CommonsLinkedHashMap(0);
        }
        CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>> commonsArrayList = new CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>>(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getKey));
        return CollectionCommonsHelper._newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super KEYTYPE> comparator) {
        ValueEnforcer.notNull(comparator, (String)"KeyComparator");
        if (CollectionHelper.isEmpty(map)) {
            return new CommonsLinkedHashMap(0);
        }
        CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>> commonsArrayList = new CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>>(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getKey, comparator));
        return CollectionCommonsHelper._newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (CollectionHelper.isEmpty(map)) {
            return new CommonsLinkedHashMap(0);
        }
        CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>> commonsArrayList = new CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>>(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getValue));
        return CollectionCommonsHelper._newOrderedMap(commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super VALUETYPE> comparator) {
        ValueEnforcer.notNull(comparator, (String)"ValueComparator");
        if (CollectionHelper.isEmpty(map)) {
            return new CommonsLinkedHashMap(0);
        }
        CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>> commonsArrayList = new CommonsArrayList<Set<Map.Entry<KEYTYPE, VALUETYPE>>>(map.entrySet());
        commonsArrayList.sort(Comparator.comparing(Map.Entry::getValue, comparator));
        return CollectionCommonsHelper._newOrderedMap(commonsArrayList);
    }
}

