/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.concurrent.Immutable;
import org.jspecify.annotations.NonNull;

@Immutable
final class OptionValidator {
    private OptionValidator() {
    }

    private static boolean _isValidShortOpt(char c) {
        return OptionValidator._isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean _isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    static void validateShortOption(@NonNull String string) {
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!OptionValidator._isValidShortOpt(c)) {
                throw new IllegalArgumentException("Illegal option name '" + c + "'");
            }
        } else {
            for (char c : string.toCharArray()) {
                if (OptionValidator._isValidChar(c)) continue;
                throw new IllegalArgumentException("The option '" + string + "' contains the illegal character '" + c + "'");
            }
        }
    }
}

