/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.cli.IOptionBase;
import com.helger.cli.Option;
import com.helger.cli.OptionBuilder;
import com.helger.cli.OptionGroup;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Options
implements ICommonsIterable<IOptionBase> {
    private final ICommonsList<IOptionBase> m_aOptions = new CommonsArrayList();

    public @Nullable Option _getFromName(String string) {
        for (IOptionBase iOptionBase : this.m_aOptions) {
            if (iOptionBase instanceof Option) {
                Option option = (Option)iOptionBase;
                if (!option.matches(string)) continue;
                return option;
            }
            Iterator iterator = ((OptionGroup)iOptionBase).iterator();
            while (iterator.hasNext()) {
                Option option = (Option)iterator.next();
                if (!option.matches(string)) continue;
                return option;
            }
        }
        return null;
    }

    public @NonNull Options addOption(@NonNull OptionBuilder optionBuilder) {
        return this.addOption(optionBuilder.build());
    }

    private void _validateOption(@NonNull Option option) {
        ValueEnforcer.notNull((Object)option, (String)"Option");
        if (option.hasShortOpt()) {
            ValueEnforcer.isNull((Object)this._getFromName(option.getShortOpt()), () -> "Another option with the short name '" + option.getShortOpt() + "' is already contained!");
        }
        if (option.hasLongOpt()) {
            ValueEnforcer.isNull((Object)this._getFromName(option.getLongOpt()), () -> "Another option with the longs name '" + option.getLongOpt() + "' is already contained!");
        }
    }

    public @NonNull Options addOption(@NonNull Option option) {
        this._validateOption(option);
        this.m_aOptions.add((Object)option);
        return this;
    }

    public @NonNull Options addOptionGroup(@NonNull OptionGroup optionGroup) {
        ValueEnforcer.notNull((Object)optionGroup, (String)"OptionGroup");
        Iterator iterator = optionGroup.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            this._validateOption(option);
        }
        this.m_aOptions.add((Object)optionGroup);
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<Option> getAllOptions() {
        return this.m_aOptions.getAllInstanceOf(Option.class);
    }

    public @NonNull Iterator<IOptionBase> iterator() {
        return this.m_aOptions.iterator();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<Option> getAllResolvedOptions() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IOptionBase iOptionBase : this.m_aOptions) {
            if (iOptionBase instanceof Option) {
                Option option = (Option)iOptionBase;
                commonsArrayList.add((Object)option);
                continue;
            }
            commonsArrayList.addAll(((OptionGroup)iOptionBase).getAllOptions());
        }
        return commonsArrayList;
    }

    public @Nullable OptionGroup getOptionGroup(@Nullable Option option) {
        if (option != null) {
            for (IOptionBase iOptionBase : this.m_aOptions) {
                OptionGroup optionGroup;
                if (!(iOptionBase instanceof OptionGroup) || !(optionGroup = (OptionGroup)iOptionBase).contains(option)) continue;
                return optionGroup;
            }
        }
        return null;
    }
}

