/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cli;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cli.IOptionBase;
import com.helger.cli.OptionBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Option
implements IOptionBase {
    public static final char DEFAULT_VALUE_SEPARATOR = '\u0000';
    public static final int INFINITE_VALUES = -1;
    static final Logger LOGGER = LoggerFactory.getLogger(Option.class);
    private final String m_sShortOpt;
    private final String m_sLongOpt;
    private final String m_sDescription;
    private final int m_nMinArgs;
    private final int m_nMaxArgs;
    private final String m_sArgName;
    private final EOptionMultiplicity m_eMultiplicity;
    private final char m_cValueSep;

    protected Option(@Nonnull OptionBuilder optionBuilder) {
        ValueEnforcer.notNull((Object)optionBuilder, (String)"Builder");
        this.m_sShortOpt = optionBuilder.m_sShortOpt;
        this.m_sLongOpt = optionBuilder.m_sLongOpt;
        this.m_sDescription = optionBuilder.m_sDescription;
        this.m_nMinArgs = optionBuilder.m_nMinArgs;
        this.m_nMaxArgs = optionBuilder.m_nMaxArgs;
        this.m_sArgName = optionBuilder.m_sArgName;
        this.m_eMultiplicity = optionBuilder.m_eMultiplicity;
        this.m_cValueSep = optionBuilder.m_cValueSep;
    }

    @Nonnull
    @Nonempty
    public final String getKey() {
        return this.hasShortOpt() ? this.m_sShortOpt : this.m_sLongOpt;
    }

    @Nullable
    public String getShortOpt() {
        return this.m_sShortOpt;
    }

    public boolean hasShortOpt() {
        return StringHelper.isNotEmpty((String)this.m_sShortOpt);
    }

    public boolean hasShortOpt(@Nullable String string) {
        return string != null && string.equals(this.m_sShortOpt);
    }

    @Nullable
    public String getLongOpt() {
        return this.m_sLongOpt;
    }

    public boolean hasLongOpt() {
        return this.m_sLongOpt != null;
    }

    public boolean hasLongOpt(@Nullable String string) {
        return string != null && string.equals(this.m_sLongOpt);
    }

    public boolean matches(@Nullable String string) {
        return string != null && (string.equals(this.m_sShortOpt) || string.equals(this.m_sLongOpt));
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    public boolean hasDescription() {
        return StringHelper.isNotEmpty((String)this.m_sDescription);
    }

    @Nonnegative
    public int getMinArgCount() {
        return this.m_nMinArgs;
    }

    public boolean hasMinArgs() {
        return this.m_nMinArgs != 0;
    }

    @Nonnegative
    public int getMaxArgCount() {
        return this.m_nMaxArgs;
    }

    public boolean hasInfiniteArgs() {
        return this.m_nMaxArgs == -1;
    }

    public boolean canHaveMoreValues(int n) {
        return this.hasInfiniteArgs() || n < this.m_nMaxArgs;
    }

    public boolean canHaveArgs() {
        return this.hasInfiniteArgs() || this.m_nMaxArgs > 0;
    }

    @Nullable
    public String getArgName() {
        return this.m_sArgName;
    }

    public boolean isRepeatable() {
        return this.m_eMultiplicity.isRepeatable();
    }

    @Override
    public boolean isRequired() {
        return this.m_eMultiplicity.isRequired();
    }

    public boolean hasArgName() {
        return StringHelper.isNotEmpty((String)this.m_sArgName);
    }

    public char getValueSeparator() {
        return this.m_cValueSep;
    }

    public boolean hasValueSeparator() {
        return this.m_cValueSep != '\u0000';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Option option = (Option)object;
        return EqualsHelper.equals((Object)this.m_sShortOpt, (Object)option.m_sShortOpt) && EqualsHelper.equals((Object)this.m_sLongOpt, (Object)option.m_sLongOpt);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sShortOpt).append((Object)this.m_sLongOpt).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Opt", (Object)this.m_sShortOpt).appendIfNotNull("LongOpt", (Object)this.m_sLongOpt).appendIfNotNull("Description", (Object)this.m_sDescription).appendIf("MinArgs", this.m_nMinArgs, this::hasMinArgs).appendIf("MaxArgs", (Object)(this.m_nMaxArgs == -1 ? "infinite" : Integer.toString(this.m_nMaxArgs)), this::canHaveArgs).appendIfNotNull("ArgName", (Object)this.m_sArgName).append("Multiplicity", (Enum)this.m_eMultiplicity).appendIf("ValueSep", this.m_cValueSep, this::hasValueSeparator).getToString();
    }

    @Nonnull
    public static OptionBuilder builder() {
        return new OptionBuilder(null);
    }

    @Nonnull
    public static OptionBuilder builder(@Nullable String string) {
        return new OptionBuilder(string);
    }

    public static enum EOptionMultiplicity {
        OPTIONAL_ONCE,
        OPTIONAL_MANY,
        REQUIRED_ONCE,
        REQUIRED_MANY;


        public boolean isOptional() {
            return this == OPTIONAL_ONCE || this == OPTIONAL_MANY;
        }

        public boolean isRequired() {
            return this == REQUIRED_ONCE || this == REQUIRED_MANY;
        }

        public boolean isOnce() {
            return this == OPTIONAL_ONCE || this == REQUIRED_ONCE;
        }

        public boolean isRepeatable() {
            return this == OPTIONAL_MANY || this == REQUIRED_MANY;
        }

        @Nonnull
        public EOptionMultiplicity getAsRequired() {
            if (this == OPTIONAL_ONCE) {
                return REQUIRED_ONCE;
            }
            if (this == OPTIONAL_MANY) {
                return REQUIRED_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsOptional() {
            if (this == REQUIRED_ONCE) {
                return OPTIONAL_ONCE;
            }
            if (this == REQUIRED_MANY) {
                return OPTIONAL_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsRepeatable() {
            if (this == OPTIONAL_ONCE) {
                return OPTIONAL_MANY;
            }
            if (this == REQUIRED_ONCE) {
                return REQUIRED_MANY;
            }
            return this;
        }

        @Nonnull
        public EOptionMultiplicity getAsOnce() {
            if (this == OPTIONAL_MANY) {
                return OPTIONAL_ONCE;
            }
            if (this == REQUIRED_MANY) {
                return REQUIRED_ONCE;
            }
            return this;
        }
    }
}

