/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bc;

import com.helger.annotation.concurrent.Immutable;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PBCProvider {
    public static final String PROVIDER_NAME_BC = "BC";
    public static final String PROVIDER_NAME_BC_FIPS = "BCFIPS";
    private static final Logger LOGGER = LoggerFactory.getLogger(PBCProvider.class);
    private static final Provider PROVIDER_BC;
    private static final PBCProvider INSTANCE;

    private PBCProvider() {
    }

    public static @NonNull Provider getProvider() {
        return PROVIDER_BC;
    }

    static {
        Provider provider = Security.getProvider(PROVIDER_NAME_BC);
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
            LOGGER.info("Just added the BouncyCastleProvider to the list of Security providers");
        } else if (!(provider instanceof BouncyCastleProvider)) {
            LOGGER.warn("Security provider 'BC' is not of type org.bouncycastle.jce.provider.BouncyCastleProvider but it is a '" + provider.getClass().getName() + "'");
        }
        PROVIDER_BC = provider;
        INSTANCE = new PBCProvider();
    }
}

