/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.rt;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class StackTraceHelper {
    public static final String DEFAULT_LINE_SEPARATOR = "\n";
    @CodingStyleguideUnaware
    private static final List<String> STACKTRACE_OMIT_UNITTEST = new ArrayList<String>();
    @CodingStyleguideUnaware
    private static final List<String> STACKTRACE_OMIT_APPSRV = new ArrayList<String>();
    private static final StackTraceHelper INSTANCE;

    private StackTraceHelper() {
    }

    private static boolean _isUnitTestLine(@NonNull String string) {
        for (String string2 : STACKTRACE_OMIT_UNITTEST) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isAppSrvLine(@NonNull String string) {
        for (String string2 : STACKTRACE_OMIT_APPSRV) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isStopStackTraceListing(@NonNull String string) {
        return StackTraceHelper._isUnitTestLine(string) || StackTraceHelper._isAppSrvLine(string);
    }

    private static boolean _matchesParentStackTrace(@NonNull StackTraceElement stackTraceElement, @Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
                if (!stackTraceElement2.equals(stackTraceElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static void _appendSingleStackTraceToString(@NonNull StringBuilder stringBuilder, @NonNull StackTraceElement[] stackTraceElementArray, @Nullable StackTraceElement[] stackTraceElementArray2, boolean bl, @NonNull String string) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string2 = stackTraceElement.toString();
            if (bl && StackTraceHelper._isStopStackTraceListing(string2) || StackTraceHelper._matchesParentStackTrace(stackTraceElement, stackTraceElementArray2)) {
                int n = stackTraceElementArray.length - i;
                stringBuilder.append("  [").append(n).append(n == 1 ? " element" : " elements").append(" omitted -- ").append(string2).append(']').append(string);
                break;
            }
            stringBuilder.append(i + 1).append(".: ").append(string2).append(string);
        }
    }

    public static void appendStackToString(@NonNull StringBuilder stringBuilder, @NonNull StackTraceElement[] stackTraceElementArray) {
        StackTraceHelper.appendStackToString(stringBuilder, stackTraceElementArray, DEFAULT_LINE_SEPARATOR);
    }

    public static void appendStackToString(@NonNull StringBuilder stringBuilder, @NonNull StackTraceElement[] stackTraceElementArray, @NonNull String string) {
        ValueEnforcer.notNull(stringBuilder, "StringBuilder");
        ValueEnforcer.notNull(stackTraceElementArray, "StackTraceElements");
        ValueEnforcer.notNull(string, "LineSeparator");
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, true, string);
    }

    public static @NonNull String getStackAsString(@NonNull StackTraceElement[] stackTraceElementArray, boolean bl) {
        return StackTraceHelper.getStackAsString(stackTraceElementArray, bl, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@NonNull StackTraceElement[] stackTraceElementArray, boolean bl, @NonNull String string) {
        ValueEnforcer.notNull(stackTraceElementArray, "StackTraceElements");
        ValueEnforcer.notNull(string, "LineSeparator");
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, bl, string);
        if (string.length() > 0 && StringHelper.endsWith((CharSequence)stringBuilder, (CharSequence)string)) {
            stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static @NonNull String getStackAsString(@NonNull StackTraceElement[] stackTraceElementArray) {
        return StackTraceHelper.getStackAsString(stackTraceElementArray, true, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@NonNull Thread thread) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), true, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@NonNull Thread thread, boolean bl) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), bl, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@NonNull Thread thread, boolean bl, @NonNull String string) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), bl, string);
    }

    public static @NonNull String getCurrentThreadStackAsString() {
        return StackTraceHelper.getStackAsString(Thread.currentThread().getStackTrace(), true, DEFAULT_LINE_SEPARATOR);
    }

    private static StringBuilder _getRecursiveStackAsStringBuilder(@NonNull Throwable throwable, @Nullable Throwable throwable2, @Nullable StringBuilder stringBuilder, @Nonnegative int n, boolean bl, @NonNull String string) {
        StringBuilder stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        stringBuilder2.append(throwable.toString()).append(string);
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder2, throwable.getStackTrace(), throwable2 == null ? null : throwable2.getStackTrace(), bl, string);
        if (throwable.getCause() != null) {
            stringBuilder2.append("==> [").append(n).append("] caused by ");
            StackTraceHelper._getRecursiveStackAsStringBuilder(throwable.getCause(), throwable, stringBuilder2, n + 1, bl, string);
        }
        return stringBuilder2;
    }

    public static @NonNull String getStackAsString(@Nullable Throwable throwable) {
        return StackTraceHelper.getStackAsString(throwable, true, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@Nullable Throwable throwable, boolean bl) {
        return StackTraceHelper.getStackAsString(throwable, bl, DEFAULT_LINE_SEPARATOR);
    }

    public static @NonNull String getStackAsString(@Nullable Throwable throwable, boolean bl, @NonNull String string) {
        ValueEnforcer.notNull(string, "LineSeparator");
        if (throwable == null) {
            return "";
        }
        StringBuilder stringBuilder = StackTraceHelper._getRecursiveStackAsStringBuilder(throwable, null, null, 1, bl, string);
        if (string.length() > 0 && StringHelper.endsWith((CharSequence)stringBuilder, (CharSequence)string)) {
            stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static boolean containsUnitTestElement(@Nullable Throwable throwable) {
        return throwable != null && StackTraceHelper.containsUnitTestElement(throwable.getStackTrace());
    }

    public static boolean containsUnitTestElement(@Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                String string = stackTraceElement.toString();
                if (!StackTraceHelper._isUnitTestLine(string)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        STACKTRACE_OMIT_UNITTEST.add("org.testng");
        STACKTRACE_OMIT_UNITTEST.add("org.junit.");
        STACKTRACE_OMIT_UNITTEST.add("junit.framework.");
        STACKTRACE_OMIT_APPSRV.add("org.apache.catalina.core");
        STACKTRACE_OMIT_APPSRV.add("org.mortbay.jetty.");
        STACKTRACE_OMIT_APPSRV.add("org.eclipse.jetty.");
        INSTANCE = new StackTraceHelper();
    }
}

