/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.BigHelper;
import com.helger.base.numeric.mutable.AbstractMutableNumeric;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableBigInteger
extends AbstractMutableNumeric<MutableBigInteger> {
    private BigInteger m_aValue;

    public MutableBigInteger(long l) {
        this(BigInteger.valueOf(l));
    }

    public MutableBigInteger(@NonNull MutableBigInteger mutableBigInteger) {
        this(mutableBigInteger.m_aValue);
    }

    public MutableBigInteger(@NonNull BigInteger bigInteger) {
        this.m_aValue = ValueEnforcer.notNull(bigInteger, "Value");
    }

    @Override
    public @NonNull BigDecimal getAsBigDecimal() {
        return new BigDecimal(this.m_aValue);
    }

    @Override
    public @NonNull BigInteger getAsBigInteger() {
        return this.m_aValue;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_aValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.m_aValue.intValue();
    }

    @Override
    public long longValue() {
        return this.m_aValue.longValue();
    }

    public @NonNull BigInteger inc() {
        return this.inc(BigInteger.ONE);
    }

    public @NonNull BigInteger inc(long l) {
        return this.inc(BigInteger.valueOf(l));
    }

    public @NonNull BigInteger inc(@NonNull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Delta");
        return this.inc(mutableBigInteger.m_aValue);
    }

    public @NonNull BigInteger inc(@NonNull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Delta");
        this.m_aValue = this.m_aValue.add(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    public @NonNull BigInteger dec() {
        return this.inc(CGlobal.BIGINT_MINUS_ONE);
    }

    public @NonNull BigInteger dec(long l) {
        return this.inc(BigInteger.valueOf(-l));
    }

    public @NonNull BigInteger dec(@NonNull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Delta");
        return this.inc(mutableBigInteger.m_aValue.negate());
    }

    public @NonNull BigInteger dec(@NonNull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Delta");
        return this.inc(bigInteger.negate());
    }

    public @NonNull BigInteger divide(long l) {
        return this.divide(BigHelper.toBigInteger(l));
    }

    public @NonNull BigInteger divide(@NonNull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Divisor");
        return this.divide(mutableBigInteger.m_aValue);
    }

    public @NonNull BigInteger divide(@NonNull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Divisor");
        this.m_aValue = this.m_aValue.divide(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    public @NonNull BigInteger multiply(long l) {
        return this.multiply(BigHelper.toBigInteger(l));
    }

    public @NonNull BigInteger multiply(@NonNull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Multiplicand");
        return this.multiply(mutableBigInteger.m_aValue);
    }

    public @NonNull BigInteger multiply(@NonNull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Multiplicand");
        this.m_aValue = this.m_aValue.multiply(bigInteger);
        this.onAfterChange();
        return this.m_aValue;
    }

    public @NonNull EChange set(long l) {
        return this.set(BigInteger.valueOf(l));
    }

    public @NonNull EChange set(@NonNull MutableBigInteger mutableBigInteger) {
        ValueEnforcer.notNull(mutableBigInteger, "Value");
        return this.set(mutableBigInteger.m_aValue);
    }

    public @NonNull EChange set(@NonNull BigInteger bigInteger) {
        ValueEnforcer.notNull(bigInteger, "Value");
        if (bigInteger.equals(this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigInteger;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return BigHelper.isEQ0(this.m_aValue);
    }

    @Override
    public boolean isLT0() {
        return BigHelper.isLT0(this.m_aValue);
    }

    @Override
    public boolean isLE0() {
        return BigHelper.isLE0(this.m_aValue);
    }

    @Override
    public boolean isGT0() {
        return BigHelper.isGT0(this.m_aValue);
    }

    @Override
    public boolean isGE0() {
        return BigHelper.isGE0(this.m_aValue);
    }

    public @NonNull BigInteger getAndInc() {
        BigInteger bigInteger = this.getAsBigInteger();
        this.inc();
        return bigInteger;
    }

    public @NonNull BigInteger incAndGet() {
        this.inc();
        return this.getAsBigInteger();
    }

    @Override
    public int compareTo(@NonNull MutableBigInteger mutableBigInteger) {
        return this.m_aValue.compareTo(mutableBigInteger.m_aValue);
    }

    @Override
    public @NonNull MutableBigInteger getClone() {
        return new MutableBigInteger(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBigInteger mutableBigInteger = (MutableBigInteger)object;
        return EqualsHelper.equals(this.m_aValue, mutableBigInteger.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).getToString();
    }
}

