/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.array.bytes;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasByteArray;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jspecify.annotations.NonNull;

@MustImplementEqualsAndHashcode
public final class ByteArrayWrapper
implements IHasByteArray {
    private final byte[] m_aBytes;
    private final int m_nOffset;
    private final int m_nLength;
    private final boolean m_bIsCopy;

    public ByteArrayWrapper(byte @NonNull [] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public ByteArrayWrapper(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBytes = bl ? ArrayHelper.getCopy(byArray, n, n2) : byArray;
        this.m_nOffset = bl ? 0 : n;
        this.m_nLength = n2;
        this.m_bIsCopy = bl;
    }

    @Override
    public boolean isCopy() {
        return this.m_bIsCopy;
    }

    @Override
    @ReturnsMutableObject
    public byte @NonNull [] bytes() {
        return this.m_aBytes;
    }

    @Override
    @Nonnegative
    public int getOffset() {
        return this.m_nOffset;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nLength;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nLength == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_nLength > 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
        return Arrays.equals(this.m_aBytes, this.m_nOffset, this.m_nOffset + this.m_nLength, byteArrayWrapper.m_aBytes, byteArrayWrapper.m_nOffset, byteArrayWrapper.m_nOffset + byteArrayWrapper.m_nLength);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBytes, this.m_nOffset, this.m_nLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("byte[]#", this.m_aBytes.length).append("Offset", this.m_nOffset).append("Length", this.m_nLength).append("IsCopy", this.m_bIsCopy).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull ByteArrayWrapper create(@NonNull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream, boolean bl) {
        return new ByteArrayWrapper(nonBlockingByteArrayOutputStream.directGetBuffer(), 0, nonBlockingByteArrayOutputStream.size(), bl);
    }

    @ReturnsMutableCopy
    public static @NonNull ByteArrayWrapper create(@NonNull String string, @NonNull Charset charset) {
        return new ByteArrayWrapper(string.getBytes(charset), false);
    }

    public static @NonNull ByteArrayWrapper create(@NonNull ByteBuffer byteBuffer, boolean bl) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset();
        int n2 = byteBuffer.position();
        return new ByteArrayWrapper(byArray, n, n2, bl);
    }
}

