/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.version;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public class Version
implements IComparable<Version> {
    public static final String DEFAULT_VERSION_STRING = "0";
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0, null);
    public static final boolean DEFAULT_PRINT_ZERO_ELEMENTS = false;
    private final int m_nMajor;
    private final int m_nMinor;
    private final int m_nMicro;
    private final String m_sQualifier;

    public Version(@Nonnegative int n) {
        this(n, 0, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2) {
        this(n, n2, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this(n, n2, n3, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nullable String string) {
        ValueEnforcer.isGE0(n, "Major");
        ValueEnforcer.isGE0(n2, "Minor");
        ValueEnforcer.isGE0(n3, "Micro");
        this.m_nMajor = n;
        this.m_nMinor = n2;
        this.m_nMicro = n3;
        this.m_sQualifier = StringHelper.isEmpty(string) ? null : string;
    }

    @Nonnegative
    public final int getMajor() {
        return this.m_nMajor;
    }

    @Nonnegative
    public final int getMinor() {
        return this.m_nMinor;
    }

    @Nonnegative
    public final int getMicro() {
        return this.m_nMicro;
    }

    @Nullable
    public final String getQualifier() {
        return this.m_sQualifier;
    }

    public final boolean hasQualifier() {
        return StringHelper.isNotEmpty(this.m_sQualifier);
    }

    @Override
    public int compareTo(@Nonnull Version version) {
        ValueEnforcer.notNull(version, "Rhs");
        int n = this.m_nMajor - version.m_nMajor;
        if (n == 0 && (n = this.m_nMinor - version.m_nMinor) == 0 && (n = this.m_nMicro - version.m_nMicro) == 0) {
            if (this.m_sQualifier != null) {
                if (version.m_sQualifier != null) {
                    n = this.m_sQualifier.compareTo(version.m_sQualifier);
                    if (n < 0) {
                        n = -1;
                    } else if (n > 0) {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else {
                n = version.m_sQualifier != null ? -1 : 0;
            }
        }
        return n;
    }

    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bl) {
        return this.getAsString(bl, false);
    }

    @Nonnull
    public String getAsString(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(this.m_sQualifier != null ? this.m_sQualifier : "");
        if (this.m_nMicro > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMicro);
        }
        if (bl2 || this.m_nMinor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMinor);
        }
        if (bl2 || this.m_nMajor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMajor);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : DEFAULT_VERSION_STRING;
    }

    @Nonnull
    @Nonempty
    public String getAsStringMajorMinor() {
        return this.m_nMajor + "." + this.m_nMinor;
    }

    @Nonnull
    @Nonempty
    public String getAsStringMajorMinorMicro() {
        return this.m_nMajor + "." + this.m_nMinor + "." + this.m_nMicro;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Version version = (Version)object;
        return this.m_nMajor == version.m_nMajor && this.m_nMinor == version.m_nMinor && this.m_nMicro == version.m_nMicro && EqualsHelper.equals(this.m_sQualifier, version.m_sQualifier);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMajor).append(this.m_nMinor).append(this.m_nMicro).append(this.m_sQualifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("major", this.m_nMajor).append("minor", this.m_nMinor).append("micro", this.m_nMicro).appendIfNotNull("qualifier", this.m_sQualifier).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    private static String[] _extSplit(@Nonnull String string) {
        String[] stringArray = StringHelper.getExplodedArray('.', string, 2);
        if (stringArray.length == 2) {
            return stringArray;
        }
        if (StringParser.isInt(stringArray[0])) {
            return stringArray;
        }
        String[] stringArray2 = StringHelper.getExplodedArray('-', string, 2);
        if (stringArray2.length == 1) {
            return stringArray;
        }
        return stringArray2;
    }

    @Nonnull
    public static Version parse(@Nullable String string) {
        String string2;
        String string3;
        String string4;
        String string5 = string4 = string == null ? "" : string.trim();
        if (string4.length() == 0) {
            return DEFAULT_VERSION;
        }
        Integer n = null;
        Integer n2 = null;
        boolean bl = false;
        String[] stringArray = Version._extSplit(string4);
        Integer n3 = StringParser.parseIntObj(stringArray[0]);
        if (n3 == null && StringHelper.isNotEmpty(stringArray[0])) {
            string3 = string4;
            bl = true;
        } else {
            string3 = null;
        }
        String string6 = string2 = !bl && stringArray.length > 1 ? stringArray[1] : null;
        if (StringHelper.isNotEmpty(string6)) {
            String string7;
            stringArray = Version._extSplit(string2);
            n = StringParser.parseIntObj(stringArray[0]);
            if (n == null && StringHelper.isNotEmpty(stringArray[0])) {
                string3 = string2;
                bl = true;
            }
            if (StringHelper.isNotEmpty(string7 = (string2 = !bl && stringArray.length > 1 ? stringArray[1] : null))) {
                stringArray = Version._extSplit(string2);
                n2 = StringParser.parseIntObj(stringArray[0]);
                if (n2 == null && StringHelper.isNotEmpty(stringArray[0])) {
                    string3 = string2;
                    bl = true;
                }
                if (!bl && stringArray.length > 1) {
                    string3 = stringArray[1];
                }
            }
        }
        int n4 = n3 == null ? 0 : n3;
        int n5 = n == null ? 0 : n;
        int n6 = n2 == null ? 0 : n2;
        string3 = StringHelper.isEmpty(string3) ? null : string3;
        return new Version(n4, n5, n6, string3);
    }

    @Nonnull
    public static Version parseDotOnly(@Nullable String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() == 0) {
            return DEFAULT_VERSION;
        }
        String[] stringArray = StringHelper.getExplodedArray('.', string2, 4);
        int n = stringArray.length > 0 ? StringParser.parseInt(stringArray[0], 0) : 0;
        int n2 = stringArray.length > 1 ? StringParser.parseInt(stringArray[1], 0) : 0;
        int n3 = stringArray.length > 2 ? StringParser.parseInt(stringArray[2], 0) : 0;
        String string4 = stringArray.length > 3 ? (StringHelper.isEmpty(stringArray[3]) ? null : stringArray[3]) : null;
        return new Version(n, n2, n3, string4);
    }
}

