/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.nonblocking;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.WrappedOutputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;

public class NonBlockingBufferedOutputStream
extends WrappedOutputStream {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingBufferedOutputStream(@Nonnull OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public NonBlockingBufferedOutputStream(@Nonnull OutputStream outputStream, @Nonnegative int n) {
        super(outputStream);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aBuf = new byte[n];
    }

    private void _flushBuffer() throws IOException {
        if (this.m_nCount > 0) {
            this.out.write(this.m_aBuf, 0, this.m_nCount);
            this.m_nCount = 0;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_nCount >= this.m_aBuf.length) {
            this._flushBuffer();
        }
        this.m_aBuf[this.m_nCount++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.m_aBuf.length) {
            this._flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.m_aBuf.length - this.m_nCount) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n, this.m_aBuf, this.m_nCount, n2);
        this.m_nCount += n2;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this.out.flush();
    }
}

