/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.Predicates;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public final class StringImplode {
    private StringImplode() {
    }

    @Nonnull
    public static ImploderBuilder imploder() {
        return new ImploderBuilder();
    }

    @Nonnull
    public static String getImploded(@Nullable Collection<?> collection) {
        return StringImplode.imploder().source(collection).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).build();
    }

    @Nonnull
    public static String getImploded(@Nonnull String string, @Nullable Collection<?> collection) {
        return StringImplode.imploder().source(collection).separator(string).build();
    }

    @Nonnull
    public static String getImploded(char c, @Nullable Collection<?> collection) {
        return StringImplode.imploder().source(collection).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).separator(c).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).separator(string).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(char c, ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringImplode.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).separator(c).build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nullable Collection<String> collection) {
        return StringImplode.imploder().source(collection).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable Collection<String> collection) {
        return StringImplode.imploder().source(collection).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable Collection<String> collection) {
        return StringImplode.imploder().source(collection).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(collection, function).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, String ... stringArray) {
        return StringImplode.imploder().source(stringArray).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, String ... stringArray) {
        return StringImplode.imploder().source(stringArray).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringImplode.imploder().source(stringArray).separator(string).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringImplode.imploder().source(stringArray).separator(c).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(string).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringImplode.imploder().source(ELEMENTTYPEArray, function).separator(c).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static ImploderBuilderMap imploderMap() {
        return new ImploderBuilderMap();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImploded(@Nonnull String string, @Nonnull String string2, @Nullable Map<KEYTYPE, VALUETYPE> map) {
        return StringImplode.imploderMap().source(map).separatorOuter(string).separatorInner(string2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImploded(char c, char c2, @Nullable Map<KEYTYPE, VALUETYPE> map) {
        return StringImplode.imploderMap().source(map).separatorOuter(c).separatorInner(c2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImplodedMapped(@Nonnull String string, @Nonnull String string2, @Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map, @Nonnull Function<? super KEYTYPE, String> function, @Nonnull Function<? super VALUETYPE, String> function2) {
        return StringImplode.imploderMap().source(map, function, function2).separatorOuter(string).separatorInner(string2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImplodedMapped(char c, char c2, @Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map, @Nonnull Function<? super KEYTYPE, String> function, @Nonnull Function<? super VALUETYPE, String> function2) {
        return StringImplode.imploderMap().source(map, function, function2).separatorOuter(c).separatorInner(c2).build();
    }

    public static class ImploderBuilder
    implements IBuilder<String> {
        private List<String> m_aSource;
        private String m_sSeparator;
        private int m_nOffset = 0;
        private int m_nLength = -1;
        private Predicate<String> m_aFilter;

        @Nullable
        private static String _toString(@Nullable Object object) {
            return object == null ? null : object.toString();
        }

        @Nonnull
        public ImploderBuilder source(@Nullable Collection<?> collection) {
            return this.source(collection, ImploderBuilder::_toString);
        }

        @Nonnull
        public <T> ImploderBuilder source(@Nullable Collection<T> collection, @Nonnull Function<? super T, String> function) {
            ValueEnforcer.notNull(function, "Mapper");
            if (collection == null) {
                this.m_aSource = null;
            } else {
                this.m_aSource = new ArrayList<String>(collection.size());
                for (T t : collection) {
                    this.m_aSource.add(function.apply(t));
                }
            }
            return this;
        }

        @Nonnull
        public ImploderBuilder source(String ... stringArray) {
            this.m_aSource = stringArray == null ? null : Arrays.asList(stringArray);
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final <T> ImploderBuilder source(T ... TArray) {
            return this.source(TArray, ImploderBuilder::_toString);
        }

        @Nonnull
        public <T> ImploderBuilder source(@Nullable T[] TArray, @Nonnull Function<? super T, String> function) {
            ValueEnforcer.notNull(function, "Mapper");
            if (TArray == null) {
                this.m_aSource = null;
            } else {
                this.m_aSource = new ArrayList<String>(TArray.length);
                for (T t : TArray) {
                    this.m_aSource.add(function.apply(t));
                }
            }
            return this;
        }

        @Nonnull
        public ImploderBuilder separator(char c) {
            return this.separator(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilder separator(@Nullable String string) {
            this.m_sSeparator = string;
            return this;
        }

        @Nonnull
        public ImploderBuilder offset(int n) {
            this.m_nOffset = n;
            return this;
        }

        @Nonnull
        public ImploderBuilder length(int n) {
            this.m_nLength = n;
            return this;
        }

        @Nonnull
        public ImploderBuilder filterNonEmpty() {
            return this.filter(StringHelper::isNotEmpty);
        }

        @Nonnull
        public ImploderBuilder filter(@Nullable Predicate<String> predicate) {
            this.m_aFilter = predicate;
            return this;
        }

        @Override
        @Nonnull
        public String build() {
            Predicate<Object> predicate;
            List<String> list = this.m_aSource;
            if (list == null || list.isEmpty() || this.m_nLength == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.m_sSeparator;
            Predicate<Object> predicate2 = predicate = this.m_aFilter == null ? Predicates.all() : this.m_aFilter;
            if (this.m_nOffset <= 0 && this.m_nLength < 0) {
                int n = 0;
                for (String string2 : list) {
                    if (!predicate.test(string2)) continue;
                    if (n > 0 && string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    ++n;
                }
            } else {
                int n = Math.max(0, this.m_nOffset);
                int n2 = list.size();
                if (this.m_nLength > 0) {
                    n2 = Math.min(n2, n + this.m_nLength);
                }
                int n3 = 0;
                for (int i = n; i < n2; ++i) {
                    String string3 = list.get(i);
                    if (!predicate.test(string3)) continue;
                    if (n3 > 0 && string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string3);
                    ++n3;
                }
            }
            return stringBuilder.toString();
        }
    }

    public static class ImploderBuilderMap
    implements IBuilder<String> {
        private Map<String, String> m_aSource;
        private String m_sSeparatorOuter;
        private String m_sSeparatorInner;
        private Predicate<String> m_aFilterKey;
        private Predicate<String> m_aFilterValue;

        @Nullable
        private static String _toString(@Nullable Object object) {
            return object == null ? null : object.toString();
        }

        @Nonnull
        public ImploderBuilderMap source(@Nullable Map<?, ?> map) {
            return this.source(map, ImploderBuilderMap::_toString, ImploderBuilderMap::_toString);
        }

        @Nonnull
        public <K, V> ImploderBuilderMap source(@Nullable Map<K, V> map, @Nonnull Function<? super K, String> function, @Nonnull Function<? super V, String> function2) {
            ValueEnforcer.notNull(function, "KeyMapper");
            ValueEnforcer.notNull(function2, "ValueMapper");
            if (map == null) {
                this.m_aSource = null;
            } else {
                this.m_aSource = new LinkedHashMap<String, String>(map.size());
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    this.m_aSource.put(function.apply(entry.getKey()), function2.apply(entry.getValue()));
                }
            }
            return this;
        }

        @Nonnull
        public ImploderBuilderMap separatorOuter(char c) {
            return this.separatorOuter(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilderMap separatorOuter(@Nullable String string) {
            this.m_sSeparatorOuter = string;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap separatorInner(char c) {
            return this.separatorInner(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilderMap separatorInner(@Nullable String string) {
            this.m_sSeparatorInner = string;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap filterKeyNonEmpty() {
            return this.filterKey(StringHelper::isNotEmpty);
        }

        @Nonnull
        public ImploderBuilderMap filterKey(@Nullable Predicate<String> predicate) {
            this.m_aFilterKey = predicate;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap filterValueNonEmpty() {
            return this.filterValue(StringHelper::isNotEmpty);
        }

        @Nonnull
        public ImploderBuilderMap filterValue(@Nullable Predicate<String> predicate) {
            this.m_aFilterValue = predicate;
            return this;
        }

        @Override
        @Nonnull
        public String build() {
            Map<String, String> map = this.m_aSource;
            if (map == null || map.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.m_sSeparatorOuter;
            String string2 = this.m_sSeparatorInner;
            Predicate<Object> predicate = this.m_aFilterKey == null ? Predicates.all() : this.m_aFilterKey;
            Predicate<Object> predicate2 = this.m_aFilterValue == null ? Predicates.all() : this.m_aFilterValue;
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                if (!predicate.test(string3) || !predicate2.test(string4)) continue;
                if (n > 0 && string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string3);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string4);
                ++n;
            }
            return stringBuilder.toString();
        }
    }
}

