/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.function.Supplier;

@Immutable
public class HasInputStream
implements IHasInputStream {
    private final Supplier<? extends InputStream> m_aISP;
    private final boolean m_bReadMultiple;

    public HasInputStream(@Nonnull Supplier<? extends InputStream> supplier, boolean bl) {
        this.m_aISP = ValueEnforcer.notNull(supplier, "ISP");
        this.m_bReadMultiple = bl;
    }

    @Override
    public final boolean isReadMultiple() {
        return this.m_bReadMultiple;
    }

    @Override
    public final InputStream getInputStream() {
        return this.m_aISP.get();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("ReadMultiple", this.m_bReadMultiple).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream multiple(@Nonnull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream once(@Nonnull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, false);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IHasInputStream create(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        ValueEnforcer.notNull(nonBlockingByteArrayOutputStream, "BAOS");
        return new HISNBBAOS(nonBlockingByteArrayOutputStream);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IHasInputStream create(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Bytes");
        return new HISByteArray(byArray);
    }

    private static final class HISNBBAOS
    implements IHasInputStream {
        private final NonBlockingByteArrayOutputStream m_aBAOS;

        public HISNBBAOS(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
            this.m_aBAOS = nonBlockingByteArrayOutputStream;
        }

        @Override
        @Nonnull
        public InputStream getInputStream() {
            return this.m_aBAOS.getAsInputStream();
        }

        @Override
        public boolean isReadMultiple() {
            return true;
        }
    }

    private static final class HISByteArray
    implements IHasInputStream {
        private final byte[] m_aBytes;

        public HISByteArray(@Nonnull byte[] byArray) {
            this.m_aBytes = byArray;
        }

        @Override
        @Nonnull
        public InputStream getInputStream() {
            return new NonBlockingByteArrayInputStream(this.m_aBytes);
        }

        @Override
        public boolean isReadMultiple() {
            return true;
        }
    }
}

