/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.base.io.stream.WrappedOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends WrappedOutputStream {
    private long m_nBytesWritten = 0L;

    public CountingOutputStream(@Nonnull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.m_nBytesWritten;
    }

    @Override
    public void write(@Nonnull byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.m_nBytesWritten += (long)n2;
    }

    @Nonnegative
    public final long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("BytesWritten", this.m_nBytesWritten).getToString();
    }
}

