/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2demo.springboot;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2servlet.AS2ReceiveXServletHandlerConstantSession;
import com.helger.as2servlet.AS2WebAppListener;
import com.helger.as2servlet.mdn.AS2MDNReceiveXServletHandlerConstantSession;
import com.helger.as2servlet.util.AS2ServletXMLSession;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.http.EHttpMethod;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xservlet.AbstractXServlet;
import com.helger.xservlet.handler.IXServletHandler;
import java.io.File;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServletConfig {
    private static final AS2ServletXMLSession AS2_SESSION;
    @Autowired
    private ServletContext m_aSC;

    private void _initScope() {
        if (!WebScopeManager.isGlobalScopePresent()) {
            AS2WebAppListener.staticInit((ServletContext)this.m_aSC);
        }
    }

    @Bean
    public ServletRegistrationBean<MyAS2ReceiveServlet> servletRegistrationBeanAS2() {
        this._initScope();
        return new ServletRegistrationBean((Servlet)new MyAS2ReceiveServlet(), new String[]{"/as2"});
    }

    @Bean
    public ServletRegistrationBean<MyAS2MDNReceiveServlet> servletRegistrationBeanMDN() {
        this._initScope();
        return new ServletRegistrationBean((Servlet)new MyAS2MDNReceiveServlet(), new String[]{"/as2mdn"});
    }

    public static void shutDown() {
        if (AS2_SESSION != null) {
            try {
                AS2_SESSION.getMessageProcessor().stopActiveModules();
            }
            catch (AS2ComponentNotFoundException aS2ComponentNotFoundException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            AS2_SESSION = new AS2ServletXMLSession(new File("config/config.xml"));
            AS2_SESSION.getMessageProcessor().startActiveModules();
        }
        catch (AS2Exception aS2Exception) {
            throw new InitializationException((Throwable)aS2Exception);
        }
    }

    public static class MyAS2MDNReceiveServlet
    extends AbstractXServlet {
        @OverridingMethodsMustInvokeSuper
        public void init() throws ServletException {
            this.settings().setMultipartEnabled(false);
            this.handlerRegistry().registerHandler(EHttpMethod.POST, (IXServletHandler)new AS2MDNReceiveXServletHandlerConstantSession((AS2Session)AS2_SESSION), false);
        }
    }

    public static class MyAS2ReceiveServlet
    extends AbstractXServlet {
        @OverridingMethodsMustInvokeSuper
        public void init() throws ServletException {
            this.settings().setMultipartEnabled(false);
            this.handlerRegistry().registerHandler(EHttpMethod.POST, (IXServletHandler)new AS2ReceiveXServletHandlerConstantSession((AS2Session)AS2_SESSION), false);
        }
    }
}

