/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view.parallax.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import com.heinrichreimersoftware.materialintro.view.parallax.Parallaxable;
import java.util.LinkedList;
import java.util.List;

public class ParallaxUtil {
    private ParallaxUtil() {
    }

    public static List<Parallaxable> findParallaxableChildren(View root) {
        LinkedList<Parallaxable> parallaxableChildrenFound = new LinkedList<Parallaxable>();
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(root);
        while (!queue.isEmpty()) {
            View child = (View)queue.remove();
            if (child instanceof Parallaxable) {
                parallaxableChildrenFound.add((Parallaxable)child);
                continue;
            }
            if (!(child instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)child;
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                queue.add(viewGroup.getChildAt(i));
            }
        }
        return parallaxableChildrenFound;
    }

    public static void setOffsetToParallaxableList(List<Parallaxable> parallaxableChildren, @FloatRange(from=-1.0, to=1.0) float offset) {
        if (!parallaxableChildren.isEmpty()) {
            for (Parallaxable parallaxable : parallaxableChildren) {
                parallaxable.setOffset(offset);
            }
        }
    }
}

