/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SlideAdapter
extends FragmentPagerAdapter {
    private List<Slide> data = new ArrayList<Slide>();
    private FragmentManager fragmentManager;

    public SlideAdapter(FragmentManager fragmentManager) {
        super(fragmentManager);
        this.fragmentManager = fragmentManager;
        this.data = new ArrayList<Slide>();
    }

    public SlideAdapter(FragmentManager fragmentManager, @NonNull Collection<? extends Slide> collection) {
        super(fragmentManager);
        this.fragmentManager = fragmentManager;
        this.data = new ArrayList<Slide>(collection);
    }

    public void addSlide(int location, Slide object) {
        if (!this.data.contains(object)) {
            this.data.add(location, object);
        }
    }

    public boolean addSlide(Slide object) {
        if (this.data.contains(object)) {
            return false;
        }
        boolean modified = this.data.add(object);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        boolean modified = false;
        int i = 0;
        for (Slide slide : collection) {
            if (this.data.contains(slide)) continue;
            this.data.add(location + i, slide);
            ++i;
            modified = true;
        }
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        boolean modified = false;
        for (Slide slide : collection) {
            if (this.data.contains(slide)) continue;
            this.data.add(slide);
            modified = true;
        }
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean clearSlides() {
        if (!this.data.isEmpty()) {
            this.data.clear();
            return true;
        }
        return false;
    }

    public boolean containsSlide(Object object) {
        return object instanceof Slide && this.data.contains(object);
    }

    public boolean containsSlides(@NonNull Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    public Slide getSlide(int location) {
        return this.data.get(location);
    }

    public Fragment getItem(int position) {
        return this.data.get(position).getFragment();
    }

    public int getItemPosition(Object object) {
        if (object instanceof Fragment) {
            this.fragmentManager.beginTransaction().detach((Fragment)object).attach((Fragment)object).commit();
        }
        return super.getItemPosition(object);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment fragment = this.getItem(position);
        if (fragment.isAdded()) {
            return fragment;
        }
        Fragment instantiatedFragment = (Fragment)super.instantiateItem(container, position);
        Slide slide = this.data.get(position);
        if (slide instanceof RestorableSlide) {
            ((RestorableSlide)slide).setFragment(instantiatedFragment);
            this.data.set(position, slide);
            if (instantiatedFragment instanceof SlideFragment && instantiatedFragment.isAdded()) {
                ((SlideFragment)instantiatedFragment).updateNavigation();
            }
        }
        return instantiatedFragment;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment == null) {
            return;
        }
        super.destroyItem(container, position, object);
    }

    @ColorRes
    public int getBackground(int position) {
        return this.data.get(position).getBackground();
    }

    @ColorRes
    public int getBackgroundDark(int position) {
        return this.data.get(position).getBackgroundDark();
    }

    public List<Slide> getSlides() {
        return this.data;
    }

    public int indexOfSlide(Object object) {
        return this.data.indexOf(object);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int getCount() {
        return this.data.size();
    }

    public int lastIndexOfSlide(Object object) {
        return this.data.lastIndexOf(object);
    }

    public Slide removeSlide(int location) {
        return this.data.remove(location);
    }

    public boolean removeSlide(Object object) {
        int locationToRemove = this.data.indexOf(object);
        if (locationToRemove >= 0) {
            this.data.remove(locationToRemove);
            return true;
        }
        return false;
    }

    public boolean removeSlides(@NonNull Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            int locationToRemove = this.data.indexOf(object);
            if (locationToRemove < 0) continue;
            this.data.remove(locationToRemove);
            modified = true;
        }
        return modified;
    }

    public boolean retainSlides(@NonNull Collection<?> collection) {
        boolean modified = false;
        for (int i = this.data.size() - 1; i >= 0; --i) {
            if (collection.contains(this.data.get(i))) continue;
            this.data.remove(i);
            modified = true;
            --i;
        }
        return modified;
    }

    public Slide setSlide(int location, Slide object) {
        if (!this.data.contains(object)) {
            return this.data.set(location, object);
        }
        return this.data.set(location, object);
    }

    public List<Slide> setSlides(List<? extends Slide> list) {
        ArrayList<Slide> oldList = new ArrayList<Slide>(this.data);
        this.data = new ArrayList<Slide>(list);
        return oldList;
    }
}

